/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.network;

import com.m4thg33k.tombmanygraves.network.packets.BasePacket;
import com.m4thg33k.tombmanygraves.network.packets.BasePacketHandler;
import com.m4thg33k.tombmanygraves.network.packets.GravePosTogglePacket;
import com.m4thg33k.tombmanygraves.network.packets.GraveRenderTogglePacket;
import com.m4thg33k.tombmanygraves.network.packets.PacketProbeFiles;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class TMGNetwork {
    public static TMGNetwork instance = new TMGNetwork();
    public final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("tombmanygraves");
    protected final BasePacketHandler handler = new BasePacketHandler();
    private int id = 0;

    public void registerPacket(Class<? extends BasePacket> packetClass) {
        TMGNetwork.registerPacketClient(packetClass);
        TMGNetwork.registerPacketServer(packetClass);
    }

    public static void registerPacketClient(Class<? extends BasePacket> packetClass) {
        TMGNetwork.registerPacketImp(packetClass, Side.CLIENT);
    }

    public static void registerPacketServer(Class<? extends BasePacket> packetClass) {
        TMGNetwork.registerPacketImp(packetClass, Side.SERVER);
    }

    public static void registerPacketImp(Class<? extends BasePacket> packetClass, Side side) {
        TMGNetwork.instance.network.registerMessage((IMessageHandler)TMGNetwork.instance.handler, packetClass, TMGNetwork.instance.id++, side);
    }

    public static void setup() {
        TMGNetwork.registerPacketServer(PacketProbeFiles.class);
        TMGNetwork.registerPacketClient(GraveRenderTogglePacket.class);
        TMGNetwork.registerPacketClient(GravePosTogglePacket.class);
    }

    public static void sendToAll(BasePacket packet) {
        TMGNetwork.instance.network.sendToAll((IMessage)packet);
    }

    public static void sendTo(BasePacket packet, EntityPlayerMP player) {
        TMGNetwork.instance.network.sendTo((IMessage)packet, player);
    }

    public static void sendToAllAround(BasePacket packet, NetworkRegistry.TargetPoint point) {
        TMGNetwork.instance.network.sendToAllAround((IMessage)packet, point);
    }

    public static void sendToDimension(BasePacket packet, int dimensionID) {
        TMGNetwork.instance.network.sendToDimension((IMessage)packet, dimensionID);
    }

    public static void sendToServer(BasePacket packet) {
        TMGNetwork.instance.network.sendToServer((IMessage)packet);
    }

    public static void sendToClients(WorldServer world, BlockPos pos, BasePacket packet) {
        Chunk chunk = world.func_175726_f(pos);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!world.func_184164_w().func_72694_a(playerMP, chunk.field_76635_g, chunk.field_76647_h)) continue;
            TMGNetwork.sendTo(packet, playerMP);
        }
    }
}

