/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.items;

import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.lib.ModConfigs;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector3f;

public class ItemDeathList
extends Item {
    public ItemDeathList() {
        this.func_77655_b("death_list");
        this.func_77625_d(1);
        this.setRegistryName("tombmanygraves", "death_list");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack held = playerIn.func_184586_b(hand);
        if (held.func_77973_b() != this || EnumHand.OFF_HAND == hand) {
            return new ActionResult(EnumActionResult.PASS, (Object)held);
        }
        playerIn.openGui((Object)TombManyGraves.INSTANCE, 0, worldIn, playerIn.func_180425_c().func_177958_n(), playerIn.func_180425_c().func_177956_o(), playerIn.func_180425_c().func_177952_p());
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        boolean isControlled;
        super.func_77624_a(stack, world, tooltip, advanced);
        boolean isShifted = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        boolean bl = isControlled = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (isShifted) {
            tooltip.add(TextFormatting.GOLD + "Right-click to view a list of everything");
            tooltip.add(TextFormatting.GOLD + "you had on you when you died.");
            tooltip.add(TextFormatting.RED + "Drop from your inventory to destroy");
        } else {
            tooltip.add(TextFormatting.ITALIC + "<Shift for explanation>");
        }
        if (isControlled) {
            tooltip.add(TextFormatting.BLUE + "\"/tmg_deathlist [player] latest\"");
            tooltip.add(TextFormatting.BLUE + "will give you a list of everything");
            tooltip.add(TextFormatting.BLUE + "from before your last death");
        } else {
            tooltip.add(TextFormatting.ITALIC + "<Control for command>");
        }
    }

    private Vector3f getEndVector(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound.func_74764_b("InventoryHolder")) {
            compound = compound.func_74775_l("InventoryHolder");
            float x = (float)compound.func_74762_e("Xcoord") + 0.5f;
            float y = (float)compound.func_74762_e("Ycoord") + 0.5f;
            float z = (float)compound.func_74762_e("Zcoord") + 0.5f;
            if (y < 0.0f) {
                return null;
            }
            return new Vector3f(x, y, z);
        }
        return null;
    }

    private Vector3f getDirectionalVector(ItemStack stack, Vector3f start) {
        Vector3f end = this.getEndVector(stack);
        if (end == null) {
            return null;
        }
        return Vector3f.sub((Vector3f)start, (Vector3f)end, null);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K || !(entityIn instanceof EntityPlayer) || ((EntityPlayer)entityIn).func_184614_ca() != stack && ((EntityPlayer)entityIn).func_184592_cb() != stack) {
            return;
        }
        if (ModConfigs.REQUIRE_SNEAK_FOR_PATH && !entityIn.func_70093_af()) {
            return;
        }
        Vector3f start = new Vector3f((float)entityIn.field_70165_t, (float)entityIn.field_70163_u + 2.5f, (float)entityIn.field_70161_v);
        Vector3f direction = this.getDirectionalVector(stack, start);
        if (direction == null || direction.length() == 0.0f) {
            return;
        }
        Vector3f normed = direction.normalise(null);
        float length = Math.min(100.0f, direction.length());
        Vector3f end = Vector3f.add((Vector3f)new Vector3f(normed.x * length, normed.y * length, normed.z * length), (Vector3f)start, null);
        TombManyGraves.proxy.particleStream(start, end);
    }
}

