/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.inventoryManagement.specialCases;

import com.m4thg33k.tombmanygraves.inventoryManagement.InventoryHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.misc.BackpackDataItems;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class WearableBackpacksHandler {
    public static final String BASE = "Base";
    public static final String STACK = "Stack";

    public static List<NBTTagCompound> getBackpackData(EntityPlayer player) {
        ArrayList<NBTTagCompound> ret = new ArrayList<NBTTagCompound>();
        IBackpack backpack = (IBackpack)player.getCapability(IBackpack.CAPABILITY, (EnumFacing)null);
        if (backpack != null && !backpack.getStack().func_190926_b()) {
            NBTBase base = backpack.getData().serializeNBT();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a(BASE, base);
            ItemStack stack = backpack.getStack();
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            compound.func_74782_a(STACK, (NBTBase)stackTag);
            BackpackHelper.setEquippedBackpack((EntityLivingBase)player, (ItemStack)ItemStack.field_190927_a, (IBackpackData)null);
            if (InventoryHolder.isItemValidForGrave(stack)) {
                ret.add(compound);
            }
        }
        return ret;
    }

    public static void insertInventory(EntityPlayer player, NBTTagCompound compound) {
        if (compound.func_74764_b(STACK)) {
            ItemStack stack = new ItemStack(compound.func_74775_l(STACK));
            NBTTagCompound base = compound.func_74775_l(BASE);
            BackpackSize size = BackpackSize.parse((NBTBase)base.func_74781_a("size"));
            BackpackDataItems data = new BackpackDataItems(size);
            data.deserializeNBT((NBTBase)base);
            if (BackpackHelper.canEquipBackpack((EntityLivingBase)player)) {
                BackpackHelper.setEquippedBackpack((EntityLivingBase)player, (ItemStack)stack, (IBackpackData)data);
            } else {
                WearableBackpacksHandler.dropBackpackAndInventoryOnGround(player, stack, (IBackpackData)data);
            }
        }
    }

    public static void forceInventory(EntityPlayer player, NBTTagCompound compound) {
        if (compound.func_74764_b(STACK) && compound.func_74764_b(BASE)) {
            ItemStack stack = new ItemStack(compound.func_74775_l(STACK));
            NBTTagCompound base = compound.func_74775_l(BASE);
            BackpackSize size = BackpackSize.parse((NBTBase)base.func_74781_a("size"));
            BackpackDataItems data = new BackpackDataItems(size);
            data.deserializeNBT((NBTBase)base);
            if (!BackpackHelper.canEquipBackpack((EntityLivingBase)player)) {
                if (BackpackHelper.getBackpack((Entity)player) != null) {
                    IBackpack currentPack = BackpackHelper.getBackpack((Entity)player);
                    WearableBackpacksHandler.dropBackpackAndInventoryOnGround(player, currentPack.getStack(), currentPack.getData());
                } else {
                    InventoryHolder.dropItem(player, player.func_184582_a(EntityEquipmentSlot.CHEST));
                }
            }
            BackpackHelper.setEquippedBackpack((EntityLivingBase)player, (ItemStack)stack, (IBackpackData)data);
        }
    }

    public static void dropInventory(EntityPlayer player, NBTTagCompound compound) {
        if (compound.func_74764_b(STACK)) {
            ItemStack stack = new ItemStack(compound.func_74775_l(STACK));
            NBTTagCompound base = compound.func_74775_l(BASE);
            BackpackSize size = BackpackSize.parse((NBTBase)base.func_74781_a("size"));
            BackpackDataItems data = new BackpackDataItems(size);
            data.deserializeNBT((NBTBase)base);
            WearableBackpacksHandler.dropBackpackAndInventoryOnGround(player, stack, (IBackpackData)data);
        }
    }

    public static void dropInventory(World world, BlockPos pos, NBTTagCompound compound) {
        if (compound.func_74764_b(STACK)) {
            ItemStack stack = new ItemStack(compound.func_74775_l(STACK));
            NBTTagCompound base = compound.func_74775_l(BASE);
            BackpackSize size = BackpackSize.parse((NBTBase)base.func_74781_a("size"));
            BackpackDataItems data = new BackpackDataItems(size);
            data.deserializeNBT((NBTBase)base);
            WearableBackpacksHandler.dropBackpackAndInventoryOnGround(world, pos, stack, (IBackpackData)data);
        }
    }

    public static void dropBackpackAndInventoryOnGround(EntityPlayer player, ItemStack packStack, IBackpackData data) {
        if (packStack.func_190926_b() || data == null) {
            return;
        }
        ItemStackHandler items = ((BackpackDataItems)data).getItems();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stack = items.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHolder.dropItem(player, stack);
        }
        InventoryHolder.dropItem(player, packStack);
    }

    public static void dropBackpackAndInventoryOnGround(World world, BlockPos pos, ItemStack packStack, IBackpackData data) {
        if (packStack.func_190926_b() || data == null) {
            return;
        }
        ItemStackHandler items = ((BackpackDataItems)data).getItems();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stack = items.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHolder.dropItem(world, pos, stack);
        }
        InventoryHolder.dropItem(world, pos, packStack);
    }

    public static ArrayList<String> getListOfItemsInInventory(NBTTagCompound compound) {
        ArrayList<String> ret = new ArrayList<String>();
        if (compound.func_74764_b(STACK)) {
            ret.add("------------------------------");
            ret.add("Wearable Backpack");
            ret.add("------------------------------");
            int itemNumber = 1;
            ItemStack stack = new ItemStack(compound.func_74775_l(STACK));
            NBTTagCompound base = compound.func_74775_l(BASE);
            BackpackSize size = new BackpackSize(9, 4);
            NBTTagCompound no_size = base.func_74775_l("items");
            BackpackDataItems data = new BackpackDataItems(size);
            data.deserializeNBT((NBTBase)no_size);
            String packName = stack.func_82833_r();
            if (packName.length() > 28) {
                packName = packName.substring(0, 25) + "...";
            }
            ret.add("Backpack name: ");
            ret.add(packName);
            ret.add(" ");
            ItemStackHandler items = data.getItems();
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack itemStack = items.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                String name = itemStack.func_82833_r();
                if (name.length() > 28) {
                    name = name.substring(0, 25) + "...";
                }
                ret.add(itemNumber + ") " + name + (itemStack.func_190916_E() > 1 ? " x" + itemStack.func_190916_E() : ""));
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                ret.addAll(enchants.keySet().stream().map(e -> " -> " + e.func_77316_c(((Integer)enchants.get(e)).intValue())).collect(Collectors.toList()));
                ++itemNumber;
            }
        }
        return ret;
    }
}

