/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.inventoryManagement;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TransitionInventory
extends InventoryBasic {
    public TransitionInventory(int slotCount) {
        super("Temp", false, slotCount);
    }

    public TransitionInventory(NBTTagList tagList) {
        this(TransitionInventory.getMaxSlotInTagList(tagList));
    }

    public NBTTagList writeToTagList(NBTTagList list) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    public void readFromTagList(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            ItemStack stack = new ItemStack(compound);
            this.func_70299_a(compound.func_74771_c("Slot") & 0xFF, stack);
        }
    }

    private static int getMaxSlotInTagList(NBTTagList tagList) {
        int max = -1;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            int val = compound.func_74771_c("Slot") & 0xFF;
            if (val <= max) continue;
            max = val;
        }
        return max + 1;
    }

    public ArrayList<String> getListOfItemsInInventory() {
        ArrayList<String> stringList = new ArrayList<String>();
        int itemNumber = 1;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack inSlot = this.func_70301_a(i);
            if (inSlot.func_190926_b()) continue;
            String name = inSlot.func_82833_r();
            if (name.length() > 28) {
                name = name.substring(0, 25) + "...";
            }
            stringList.add(itemNumber + ") " + name + (inSlot.func_190916_E() > 1 ? " x" + inSlot.func_190916_E() : ""));
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)inSlot);
            stringList.addAll(enchants.keySet().stream().map(e -> "  -> " + e.func_77316_c(((Integer)enchants.get(e)).intValue())).collect(Collectors.toList()));
            ++itemNumber;
        }
        return stringList;
    }
}

