/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.inventoryManagement;

import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.inventoryManagement.BaubleInventoryHandler;
import com.m4thg33k.tombmanygraves.inventoryManagement.TransitionInventory;
import com.m4thg33k.tombmanygraves.inventoryManagement.specialCases.InventoryPetsHandler;
import com.m4thg33k.tombmanygraves.inventoryManagement.specialCases.WearableBackpacksHandler;
import com.m4thg33k.tombmanygraves.items.ItemDeathList;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryHolder {
    public static final String TAG_NAME = "InventoryHolder";
    public static final String PLAYER_INVENTORY = "PlayerInventory";
    public static final String EMPTY = "IsEmpty";
    public static final String TIMESTAMP = "Timestamp";
    public static final String PLAYER_NAME = "PlayerName";
    public static final String BAUBLE_INVENTORY = "BaubleInventory";
    public static final String X = "Xcoord";
    public static final String Y = "Ycoord";
    public static final String Z = "Zcoord";
    public static final String INVENTORY = "Inventory";
    public static final String WEARABLE_BACKPACKS_INVENTORY = "WBInventory";
    public static final String COSMETIC_ARMOR_INVENTORY = "CosmeticArmorInventory";
    private NBTTagCompound compound = new NBTTagCompound();
    private boolean isEmpty = true;
    private String timestamp = "";
    private int xcoord = -1;
    private int ycoord = -1;
    private int zcoord = -1;
    private String playerName = "unknown";

    public boolean isInventoryEmpty() {
        return this.isEmpty;
    }

    public void grabPlayerData(EntityPlayer player) {
        this.compound = new NBTTagCompound();
        boolean gravePetCollecting = false;
        if (TombManyGraves.INVENTORY_PETS) {
            if (InventoryPetsHandler.isGravePetActive(player)) {
                gravePetCollecting = true;
            } else {
                InventoryPetsHandler.resetGravePet(player);
            }
        }
        if (TombManyGraves.WEARABLE_BACKPACKS) {
            List<NBTTagCompound> wback = WearableBackpacksHandler.getBackpackData(player);
            if (wback.size() == 1) {
                this.compound.func_74782_a(WEARABLE_BACKPACKS_INVENTORY, (NBTBase)wback.get(0));
                this.isEmpty = false;
            } else {
                this.compound.func_74782_a(WEARABLE_BACKPACKS_INVENTORY, (NBTBase)new NBTTagCompound());
            }
        }
        if (!gravePetCollecting) {
            this.compound.func_74782_a(PLAYER_INVENTORY, (NBTBase)this.getTagFromInventory((IInventory)player.field_71071_by));
        }
        if (TombManyGraves.BAUBLES) {
            List<NBTTagCompound> baubles = BaubleInventoryHandler.getBaubleData(player);
            if (baubles.size() == 1) {
                this.compound.func_74782_a(BAUBLE_INVENTORY, (NBTBase)baubles.get(0));
                this.isEmpty = false;
            } else {
                this.compound.func_74782_a(BAUBLE_INVENTORY, (NBTBase)new NBTTagCompound());
            }
        } else {
            this.compound.func_74782_a(BAUBLE_INVENTORY, (NBTBase)new NBTTagCompound());
        }
        this.playerName = player.func_70005_c_();
        this.compound.func_74778_a(PLAYER_NAME, this.playerName);
        this.setTimestamp(new SimpleDateFormat("MM_dd_YYYY_HH_mm_ss").format(new Date()));
    }

    public void grabPlayerData(EntityPlayer player, BlockPos pos) {
        this.grabPlayerData(player);
        this.setPosition(pos);
    }

    public void setPosition(BlockPos pos) {
        this.xcoord = pos.func_177958_n();
        this.ycoord = pos.func_177956_o();
        this.zcoord = pos.func_177952_p();
        this.compound.func_74768_a(X, this.xcoord);
        this.compound.func_74768_a(Y, this.ycoord);
        this.compound.func_74768_a(Z, this.zcoord);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public BlockPos getPosition() {
        return new BlockPos(this.xcoord, this.ycoord, this.zcoord);
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        this.compound.func_74778_a(TIMESTAMP, timestamp);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    private NBTTagList getTagFromInventory(IInventory inventory) {
        TransitionInventory copy = new TransitionInventory(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!InventoryHolder.isItemValidForGrave(stack)) continue;
            copy.func_70299_a(i, stack.func_77946_l());
            inventory.func_70299_a(i, ItemStack.field_190927_a);
            this.isEmpty = false;
        }
        return copy.writeToTagList(new NBTTagList());
    }

    public static boolean isItemValidForGrave(ItemStack stack) {
        return !stack.func_190926_b() && !(stack.func_77973_b() instanceof ItemDeathList) && stack.func_77973_b() != Item.func_150898_a((Block)ModBlocks.blockGrave);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound inCompound) {
        inCompound.func_74782_a(TAG_NAME, (NBTBase)this.compound);
        inCompound.func_74757_a(EMPTY, this.isEmpty);
        return inCompound;
    }

    public void readFromNBT(NBTTagCompound inCompound) {
        if (inCompound.func_74764_b(TAG_NAME)) {
            this.compound = inCompound.func_74775_l(TAG_NAME);
            this.isEmpty = inCompound.func_74767_n(EMPTY);
            this.xcoord = this.compound.func_74762_e(X);
            this.ycoord = this.compound.func_74762_e(Y);
            this.zcoord = this.compound.func_74762_e(Z);
            this.timestamp = this.compound.func_74779_i(TIMESTAMP);
            this.playerName = this.compound.func_74779_i(PLAYER_NAME);
        } else {
            this.compound = new NBTTagCompound();
            this.isEmpty = true;
            this.xcoord = -1;
            this.ycoord = -1;
            this.zcoord = -1;
            this.timestamp = "";
            this.playerName = "unknown";
        }
    }

    public void insertInventory(EntityPlayer player) {
        if (this.isEmpty) {
            return;
        }
        TransitionInventory saved = this.getSavedPlayerInventory(player);
        for (int i = 0; i < saved.func_70302_i_(); ++i) {
            ItemStack inSaved = saved.func_70301_a(i);
            if (inSaved.func_190926_b()) continue;
            if (player.field_71071_by.func_70301_a(i).func_190926_b()) {
                player.field_71071_by.func_70299_a(i, inSaved);
                continue;
            }
            InventoryHolder.dropItem(player, inSaved);
        }
        if (TombManyGraves.BAUBLES) {
            BaubleInventoryHandler.insertInventory(player, this.compound.func_74775_l(BAUBLE_INVENTORY));
        }
        if (TombManyGraves.WEARABLE_BACKPACKS) {
            WearableBackpacksHandler.insertInventory(player, this.compound.func_74775_l(WEARABLE_BACKPACKS_INVENTORY));
        }
        if (TombManyGraves.COSMETIC_ARMOR) {
            // empty if block
        }
    }

    public void forceInventory(EntityPlayer player) {
        if (this.isEmpty) {
            return;
        }
        TransitionInventory saved = this.getSavedPlayerInventory(player);
        for (int i = 0; i < saved.func_70302_i_(); ++i) {
            ItemStack inSaved = saved.func_70301_a(i);
            if (inSaved.func_190926_b()) continue;
            ItemStack onPlayer = player.field_71071_by.func_70301_a(i).func_77946_l();
            player.field_71071_by.func_70299_a(i, inSaved);
            if (onPlayer.func_190926_b()) continue;
            InventoryHolder.dropItem(player, onPlayer);
        }
        if (TombManyGraves.BAUBLES) {
            BaubleInventoryHandler.forceInventory(player, this.compound.func_74775_l(BAUBLE_INVENTORY));
        }
        if (TombManyGraves.WEARABLE_BACKPACKS) {
            WearableBackpacksHandler.forceInventory(player, this.compound.func_74775_l(WEARABLE_BACKPACKS_INVENTORY));
        }
        if (TombManyGraves.COSMETIC_ARMOR) {
            // empty if block
        }
    }

    public void dropInventory(EntityPlayer player) {
        TransitionInventory saved = this.getSavedPlayerInventory(player);
        for (int i = 0; i < saved.func_70302_i_(); ++i) {
            ItemStack stack = saved.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            InventoryHolder.dropItem(player, stack);
        }
        if (TombManyGraves.BAUBLES) {
            BaubleInventoryHandler.dropInventory(player, this.compound.func_74775_l(BAUBLE_INVENTORY));
        }
        if (TombManyGraves.WEARABLE_BACKPACKS) {
            WearableBackpacksHandler.dropInventory(player, this.compound.func_74775_l(WEARABLE_BACKPACKS_INVENTORY));
        }
        if (TombManyGraves.COSMETIC_ARMOR) {
            // empty if block
        }
    }

    public void dropInventory(World world, BlockPos pos) {
        TransitionInventory saved = this.getSavedPlayerInventory();
        for (int i = 0; i < saved.func_70302_i_(); ++i) {
            ItemStack stack = saved.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            InventoryHolder.dropItem(world, pos, stack);
        }
        if (TombManyGraves.BAUBLES) {
            BaubleInventoryHandler.dropInventory(world, pos, this.compound.func_74775_l(BAUBLE_INVENTORY));
        }
        if (TombManyGraves.WEARABLE_BACKPACKS) {
            WearableBackpacksHandler.dropInventory(world, pos, this.compound.func_74775_l(WEARABLE_BACKPACKS_INVENTORY));
        }
        if (TombManyGraves.COSMETIC_ARMOR) {
            // empty if block
        }
    }

    public static void dropItem(EntityPlayer player, ItemStack stack) {
        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack);
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    private TransitionInventory getSavedPlayerInventory(EntityPlayer player) {
        TransitionInventory saved = new TransitionInventory(player.field_71071_by.func_70302_i_());
        saved.readFromTagList(this.compound.func_150295_c(PLAYER_INVENTORY, 10));
        return saved;
    }

    private TransitionInventory getSavedPlayerInventory() {
        NBTTagList list = this.compound.func_150295_c(PLAYER_INVENTORY, 10);
        TransitionInventory saved = new TransitionInventory(list);
        saved.readFromTagList(this.compound.func_150295_c(PLAYER_INVENTORY, 10));
        return saved;
    }

    public ArrayList<String> createListOfItemsInMainInventory() {
        TransitionInventory saved = this.getSavedPlayerInventory();
        ArrayList<String> ret = saved.getListOfItemsInInventory();
        ret.add(0, "Main Inventory");
        ret.add(1, "------------------------------");
        ret.add(0, "------------------------------");
        return ret;
    }

    public ArrayList<String> getListOfBaubles() {
        if (TombManyGraves.BAUBLES) {
            return BaubleInventoryHandler.getListOfItemsInInventory(this.compound.func_74775_l(BAUBLE_INVENTORY));
        }
        return new ArrayList<String>();
    }

    public ArrayList<String> getListOfItemsInWearableBackpack() {
        if (TombManyGraves.WEARABLE_BACKPACKS) {
            return WearableBackpacksHandler.getListOfItemsInInventory(this.compound.func_74775_l(WEARABLE_BACKPACKS_INVENTORY));
        }
        return new ArrayList<String>();
    }

    public ArrayList<String> getListOfItemsInCosmeticArmor() {
        if (TombManyGraves.COSMETIC_ARMOR) {
            // empty if block
        }
        return new ArrayList<String>();
    }

    public static ArrayList<String> getListOfItemsInInventory(NBTTagCompound compound, String invName) {
        ArrayList<String> ret = new ArrayList<String>();
        if (compound.func_74764_b(INVENTORY)) {
            ret.add("------------------------------");
            ret.add(invName);
            ret.add("------------------------------");
            int itemNumber = 1;
            NBTTagList list = compound.func_150295_c(INVENTORY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack stack = new ItemStack(tag);
                String name = stack.func_82833_r();
                if (name.length() > 28) {
                    name = name.substring(0, 25) + "...";
                }
                ret.add(itemNumber + ") " + name + (stack.func_190916_E() > 1 ? " x" + stack.func_190916_E() : ""));
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
                ret.addAll(enchants.keySet().stream().map(e -> "  -> " + e.func_77316_c(((Integer)enchants.get(e)).intValue())).collect(Collectors.toList()));
                ++itemNumber;
            }
        }
        return ret;
    }
}

