/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.inventoryManagement;

import baubles.api.BaublesApi;
import baubles.api.cap.BaublesContainer;
import com.m4thg33k.tombmanygraves.inventoryManagement.InventoryHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BaubleInventoryHandler {
    public static final String INVENTORY = "Inventory";
    public static final String SLOT = "Slot";

    public static List<NBTTagCompound> getBaubleData(EntityPlayer player) {
        ArrayList<NBTTagCompound> ret = new ArrayList<NBTTagCompound>();
        BaublesContainer container = (BaublesContainer)BaublesApi.getBaublesHandler((EntityPlayer)player);
        NBTTagCompound compound = new NBTTagCompound();
        boolean grabbedItems = false;
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack stack = container.getStackInSlot(i);
            if (!InventoryHolder.isItemValidForGrave(stack)) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(SLOT, (byte)i);
            stack.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
            container.setStackInSlot(i, ItemStack.field_190927_a);
            grabbedItems = true;
        }
        if (grabbedItems) {
            compound.func_74782_a(INVENTORY, (NBTBase)list);
            ret.add(compound);
        }
        return ret;
    }

    public static void insertInventory(EntityPlayer player, NBTTagCompound compound) {
        if (compound.func_74764_b(INVENTORY)) {
            BaublesContainer container = (BaublesContainer)BaublesApi.getBaublesHandler((EntityPlayer)player);
            NBTTagList list = compound.func_150295_c(INVENTORY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack stack = new ItemStack(tag);
                byte slot = tag.func_74771_c(SLOT);
                if (!container.getStackInSlot((int)slot).func_190926_b()) {
                    InventoryHolder.dropItem(player, stack);
                    continue;
                }
                container.setStackInSlot((int)slot, stack);
            }
        }
    }

    public static void forceInventory(EntityPlayer player, NBTTagCompound compound) {
        if (compound.func_74764_b(INVENTORY)) {
            BaublesContainer container = (BaublesContainer)BaublesApi.getBaublesHandler((EntityPlayer)player);
            NBTTagList list = compound.func_150295_c(INVENTORY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack stack = new ItemStack(tag);
                byte slot = tag.func_74771_c(SLOT);
                if (!container.getStackInSlot((int)slot).func_190926_b()) {
                    InventoryHolder.dropItem(player, container.getStackInSlot((int)slot));
                }
                container.setStackInSlot((int)slot, stack);
            }
        }
    }

    public static void dropInventory(EntityPlayer player, NBTTagCompound compound) {
        if (compound.func_74764_b(INVENTORY)) {
            NBTTagList list = compound.func_150295_c(INVENTORY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack stack = new ItemStack(tag);
                InventoryHolder.dropItem(player, stack);
            }
        }
    }

    public static void dropInventory(World world, BlockPos pos, NBTTagCompound compound) {
        if (compound.func_74764_b(INVENTORY)) {
            NBTTagList list = compound.func_150295_c(INVENTORY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack stack = new ItemStack(tag);
                if (stack.func_190926_b()) continue;
                InventoryHolder.dropItem(world, pos, stack);
            }
        }
    }

    public static ArrayList<String> getListOfItemsInInventory(NBTTagCompound compound) {
        return InventoryHolder.getListOfItemsInInventory(compound, "Baubles");
    }
}

