/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.friendSystem;

import com.m4thg33k.tombmanygraves.util.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FriendHandler {
    private static String PREFIX = "./TombManyGraves";
    private static String FILE = "./TombManyGraves/friends.fdat";
    private static HashMap<UUID, HashSet<UUID>> friendList;

    public static void importFriendsList() {
        friendList = null;
        try {
            FriendHandler.checkFilePath();
            FileInputStream fileIn = new FileInputStream(FILE);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            friendList = (HashMap)in.readObject();
            in.close();
            fileIn.close();
            LogHelper.info("Successfully loaded the friend list.");
        }
        catch (Exception i) {
            LogHelper.warn("Could not find friend list file. Creating a new one.");
            friendList = new HashMap();
        }
        FriendHandler.writeFriends();
    }

    public static boolean checkFilePath() {
        File file = new File(PREFIX);
        return file.exists() || file.mkdirs();
    }

    public static boolean hasAsFriend(UUID player1, UUID player2) {
        return friendList != null && friendList.containsKey(player1) && friendList.get(player1).contains(player2);
    }

    public static void writeFriends() {
        try {
            FriendHandler.checkFilePath();
            FileOutputStream fileOut = new FileOutputStream(FILE);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(friendList);
            out.close();
            fileOut.close();
        }
        catch (IOException i) {
            i.printStackTrace();
        }
    }

    public static boolean hasFriendList(UUID playerID) {
        return friendList != null && friendList.containsKey(playerID);
    }

    public static void createFriendListFor(UUID playerID) {
        if (friendList.containsKey(playerID)) {
            return;
        }
        friendList.put(playerID, new HashSet());
        FriendHandler.writeFriends();
    }

    public static HashSet<UUID> getFriendSetFor(UUID playerID) {
        if (friendList.containsKey(playerID)) {
            return friendList.get(playerID);
        }
        return null;
    }

    public static List<String> getFriendStringListFor(MinecraftServer server, UUID playerID) {
        ArrayList<String> names = new ArrayList<String>();
        HashSet<UUID> friends = FriendHandler.getFriendSetFor(playerID);
        if (friends != null) {
            for (UUID id : friends) {
                try {
                    names.add(server.func_152358_ax().func_152652_a(id).getName());
                }
                catch (NullPointerException e) {
                    LogHelper.error("Error getting name for id: " + id.toString());
                }
            }
        }
        return names;
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            FriendHandler.createFriendListFor(event.getEntity().func_110124_au());
        }
    }

    public static boolean addFriendToList(UUID owner, UUID friend) {
        if (friendList != null) {
            if (friendList.containsKey(owner)) {
                boolean answer = friendList.get(owner).add(friend);
                FriendHandler.writeFriends();
                return answer;
            }
            FriendHandler.createFriendListFor(owner);
            boolean answer = friendList.get(owner).add(friend);
            FriendHandler.writeFriends();
            return answer;
        }
        return false;
    }

    public static void printFriendList(MinecraftServer server, EntityPlayer player) {
        UUID playerID = player.func_110124_au();
        List<String> friends = FriendHandler.getFriendStringListFor(server, playerID);
        if (friends.size() == 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("You have not added any friends yet."));
            return;
        }
        for (String name : friends) {
            player.func_145747_a((ITextComponent)new TextComponentString(name));
        }
    }

    public static boolean removeFriend(UUID owner, UUID friend) {
        if (friendList != null && friendList.containsKey(owner)) {
            boolean answer = friendList.get(owner).remove(friend);
            FriendHandler.writeFriends();
            return answer;
        }
        return false;
    }

    public static void clearFriends(UUID owner) {
        if (friendList != null && friendList.containsKey(owner)) {
            friendList.get(owner).clear();
            FriendHandler.writeFriends();
        }
    }

    public static boolean isFriendOf(UUID owner, UUID friend) {
        return friendList != null && friendList.containsKey(owner) && friendList.get(owner).contains(friend);
    }
}

