/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.commands;

import com.m4thg33k.tombmanygraves.commands.CommandBase;
import com.m4thg33k.tombmanygraves.inventoryManagement.DeathInventoryHandler;
import com.m4thg33k.tombmanygraves.inventoryManagement.InventoryHolder;
import com.m4thg33k.tombmanygraves.lib.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandRestoreInventory
extends CommandBase {
    public CommandRestoreInventory() {
        super("tmg_restore", 2, false);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_71518_a(ICommandSender sender) {
        return this.COMMAND_NAME + " <player> <timestamp or latest> [receiving player]";
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer receiver;
        if (sender.func_130014_f_().field_72995_K) {
            return;
        }
        if (!ModConfigs.ALLOW_INVENTORY_SAVES) {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command has been disabled."));
            return;
        }
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        EntityPlayer entityPlayer = receiver = args.length > 2 ? sender.func_130014_f_().func_72924_a(args[2]) : sender.func_130014_f_().func_72924_a(args[0]);
        if (receiver == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Either the owning or receiving player is offline."));
            return;
        }
        NBTTagCompound savedData = DeathInventoryHandler.getSavedInventoryAsNBT(args[0], args[1]);
        if (savedData == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Either the owning player is misspelled or the timestamp is invalid"));
            return;
        }
        InventoryHolder holder = new InventoryHolder();
        holder.readFromNBT(savedData);
        holder.forceInventory(receiver);
        sender.func_145747_a((ITextComponent)new TextComponentString("Inventory restored."));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1 || args.length == 3) {
            return CommandRestoreInventory.getListOfStringMatchingLastWord(args, server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandRestoreInventory.getListOfStringMatchingLastWord(args, DeathInventoryHandler.getFilenames(args[0]));
        }
        return new ArrayList<String>();
    }

    @ParametersAreNonnullByDefault
    public boolean func_82358_a(String[] args, int index) {
        return index == 0 || index == 2;
    }
}

