/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.commands;

import com.m4thg33k.tombmanygraves.commands.CommandBase;
import com.m4thg33k.tombmanygraves.friendSystem.FriendHandler;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandFriends
extends CommandBase {
    public static List<String> parameters = new ArrayList<String>();

    public CommandFriends() {
        super("tmg_friends", 0, true);
        parameters.add("add");
        parameters.add("remove");
        parameters.add("list");
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_71518_a(ICommandSender sender) {
        return this.COMMAND_NAME + " [add/remove/list] [player]";
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer) || ((EntityPlayer)sender).field_70170_p.field_72995_K) {
            return;
        }
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid usage: " + this.func_71518_a(sender)));
        } else if (args.length == 1) {
            if (args[0].equals("list")) {
                FriendHandler.printFriendList(server, (EntityPlayer)sender);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid usage: " + this.func_71518_a(sender)));
            }
        } else if (args.length == 2) {
            if (args[0].equals("list")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid usage: " + this.func_71518_a(sender)));
            } else if (args[0].equals("add")) {
                if (sender.func_70005_c_().toLowerCase().equals(args[1].toLowerCase())) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("You cannot add yourself to your friends."));
                } else {
                    GameProfile profile = server.func_152358_ax().func_152655_a(args[1]);
                    if (profile == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("That player doesn't seem to exist."));
                        return;
                    }
                    UUID friend = profile.getId();
                    if (FriendHandler.addFriendToList(((EntityPlayer)sender).func_110124_au(), friend)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Added " + args[1] + " to your friends."));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Unable to add " + args[1] + "."));
                        sender.func_145747_a((ITextComponent)new TextComponentString("Maybe they were already there?"));
                    }
                }
            } else if (args[0].equals("remove")) {
                GameProfile profile = server.func_152358_ax().func_152655_a(args[1]);
                if (profile == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("That player doesn't seem to exist."));
                    return;
                }
                UUID friend = profile.getId();
                if (FriendHandler.removeFriend(((EntityPlayer)sender).func_110124_au(), friend)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Removed " + args[1] + "."));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Unable to remove " + args[1] + "."));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Maybe they never existed?"));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid usage: " + this.func_71518_a(sender)));
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandFriends.getListOfStringMatchingLastWord(args, parameters);
        }
        if (args.length == 2) {
            if (args[0].equals("add")) {
                return CommandFriends.getListOfStringMatchingLastWord(args, server.func_71213_z());
            }
            if (args[0].equals("remove") && sender instanceof EntityPlayer) {
                return CommandFriends.getListOfStringMatchingLastWord(args, FriendHandler.getFriendStringListFor(server, ((EntityPlayer)sender).func_110124_au()));
            }
            return new ArrayList<String>();
        }
        return new ArrayList<String>();
    }

    @ParametersAreNonnullByDefault
    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }
}

