/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.render.tiles;

import com.m4thg33k.tombmanygraves.lib.ModConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileGrave;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TileGraveRenderer
extends TileEntitySpecialRenderer<TileGrave> {
    RenderItem itemRenderer;
    private int skullMeta = ModConfigs.GRAVE_SKULL_RENDER_TYPE;
    private static final ItemStack defaultSkull = new ItemStack(Items.field_151144_bL, 1, ModConfigs.GRAVE_SKULL_RENDER_TYPE);
    private int deathAngle;
    private boolean shouldRenderGround;
    private ItemStack skull = defaultSkull;
    private static final ResourceLocation TEX = TextureMap.field_110575_b;
    private Random rand;

    public TileGraveRenderer() {
        this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
    }

    private void initialize(TileGrave grave) {
        this.deathAngle = grave.getAngle() + 180;
        this.shouldRenderGround = grave.getShouldRenderGround();
        this.skull = this.skullMeta == 3 ? grave.getSkull() : defaultSkull;
        this.rand = new Random(grave.func_174877_v().hashCode());
    }

    public void render(TileGrave te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!ModConfigs.GRAVE_RENDERING_ENABLED) {
            return;
        }
        this.initialize(te);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEX);
        if (this.shouldRenderGround) {
            this.renderGround(x, y, z, te.isLocked());
        } else {
            this.renderFloatingHead(x, y, z, te.isLocked());
        }
    }

    private void renderGround(double x, double y, double z, boolean isLocked) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(-this.deathAngle), (float)0.0f, (float)1.0f, (float)0.0f);
        if (isLocked) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)0.0);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        try {
            this.itemRenderer.func_181564_a(this.skull, ItemCameraTransforms.TransformType.FIXED);
        }
        catch (Exception e) {
            this.itemRenderer.func_181564_a(new ItemStack(Blocks.field_150483_bI), ItemCameraTransforms.TransformType.FIXED);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.0);
        GlStateManager.func_179152_a((float)2.0f, (float)1.0f, (float)2.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private void renderFloatingHead(double x, double y, double z, boolean isLocked) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)this.getNextRandomAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.getNextRandomAngle(), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.getNextRandomAngle(), (float)0.0f, (float)0.0f, (float)1.0f);
        double scale = isLocked ? 0.25 : 0.75;
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        try {
            this.itemRenderer.func_181564_a(this.skull, ItemCameraTransforms.TransformType.FIXED);
        }
        catch (Exception e) {
            this.itemRenderer.func_181564_a(new ItemStack(Blocks.field_150483_bI), ItemCameraTransforms.TransformType.FIXED);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private float getNextRandomAngle() {
        return (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) + (float)this.rand.nextInt(360);
    }
}

