/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.feature.UndergroundBiomes;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeLava
extends BasicUndergroundBiome {
    int lavaChance;
    int obsidianChance;
    boolean usePackedIce;

    public UndergroundBiomeLava() {
        super(Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), true);
    }

    @Override
    public void fillCeiling(World world, BlockPos pos, IBlockState state) {
        if (UndergroundBiomes.firestoneEnabled && world.field_73012_v.nextBoolean()) {
            world.func_180501_a(pos, UndergroundBiomes.firestoneState, 2);
        } else {
            super.fillCeiling(world, pos, state);
        }
    }

    @Override
    public void fillWall(World world, BlockPos pos, IBlockState state) {
        if (UndergroundBiomes.firestoneEnabled) {
            world.func_180501_a(pos, UndergroundBiomes.firestoneState, 2);
        } else {
            super.fillWall(world, pos, state);
        }
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        if (this.lavaChance > 0 && !this.isBorder(world, pos, state) && world.field_73012_v.nextInt(this.lavaChance) == 0) {
            world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        } else if (this.obsidianChance > 0 && world.field_73012_v.nextInt(this.obsidianChance) == 0) {
            world.func_180501_a(pos, Blocks.field_150343_Z.func_176223_P(), 2);
        } else if (UndergroundBiomes.firestoneEnabled) {
            world.func_180501_a(pos, UndergroundBiomes.firestoneState, 2);
        } else {
            super.fillFloor(world, pos, state);
        }
    }

    @Override
    public void setupConfig(String category) {
        this.lavaChance = ModuleLoader.config.getInt("Lava Chance", category, 4, 0, Integer.MAX_VALUE, "The higher, the less lava will spawn");
        this.obsidianChance = ModuleLoader.config.getInt("Obsidian Chance", category, 16, 0, Integer.MAX_VALUE, "The higher, the less obsidian will spawn");
    }
}

