/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.BiomeTypeConfigHandler;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockLimestone;
import vazkii.quark.world.block.BlockMarble;
import vazkii.quark.world.block.slab.BlockLimestoneSlab;
import vazkii.quark.world.block.slab.BlockMarbleSlab;
import vazkii.quark.world.block.stairs.BlockLimestoneStairs;
import vazkii.quark.world.block.stairs.BlockMarbleStairs;
import vazkii.quark.world.world.StoneInfoBasedGenerator;

public class RevampStoneGen
extends Feature {
    public static BlockMod marble;
    public static BlockMod limestone;
    boolean enableStairsAndSlabs;
    boolean enableWalls;
    boolean outputCSV;
    public static boolean generateBasedOnBiomes;
    public static boolean enableMarble;
    public static boolean enableLimestone;
    public static StoneInfo graniteInfo;
    public static StoneInfo dioriteInfo;
    public static StoneInfo andesiteInfo;
    public static StoneInfo marbleInfo;
    public static StoneInfo limestoneInfo;
    private static List<StoneInfoBasedGenerator> generators;

    @Override
    public void setupConfig() {
        this.enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        this.enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
        enableMarble = this.loadPropBool("Enable Marble", "", true);
        enableLimestone = this.loadPropBool("Enable Limestone", "", true);
        generateBasedOnBiomes = this.loadPropBool("Generate Based on Biomes", "Note: The stone rarity values are tuned based on this being true. If you turn it off, also change the stones' rarity (around 50 is fine).", true);
        this.outputCSV = this.loadPropBool("Output CSV Debug Info", "If this is true, CSV debug info will be printed out to the console on init, to help test biome spreads.", false);
        int defSize = 14;
        int defRarity = 9;
        int defUpper = 80;
        int defLower = 20;
        graniteInfo = this.loadStoneInfo("granite", defSize, defRarity, defUpper, defLower, true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        dioriteInfo = this.loadStoneInfo("diorite", defSize, defRarity, defUpper, defLower, true, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MUSHROOM);
        andesiteInfo = this.loadStoneInfo("andesite", defSize, defRarity, defUpper, defLower, true, BiomeDictionary.Type.FOREST);
        marbleInfo = this.loadStoneInfo("marble", defSize, defRarity, defUpper, defLower, enableMarble, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SNOWY);
        limestoneInfo = this.loadStoneInfo("limestone", defSize, defRarity, defUpper, defLower, enableLimestone, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.JUNGLE);
    }

    public StoneInfo loadStoneInfo(String name, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled, BiomeDictionary.Type ... biomes) {
        return RevampStoneGen.loadStoneInfo(this.configCategory, name, clusterSize, clusterRarity, upperBound, lowerBound, enabled, "0", biomes);
    }

    public static StoneInfo loadStoneInfo(String configCategory, String name, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled, String dims, BiomeDictionary.Type ... biomes) {
        String category = configCategory + "." + name;
        StoneInfo info = new StoneInfo(category, clusterSize, clusterRarity, upperBound, lowerBound, enabled, dims, biomes);
        return info;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableMarble) {
            marble = new BlockMarble();
            if (this.enableStairsAndSlabs) {
                BlockModSlab.initSlab((Block)marble, (int)0, (BlockModSlab)new BlockMarbleSlab(false), (BlockModSlab)new BlockMarbleSlab(true));
                BlockModStairs.initStairs((Block)marble, (int)0, (BlockStairs)new BlockMarbleStairs());
            }
            VanillaWalls.add("marble", (Block)marble, 0, this.enableWalls);
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)marble, (int)4, (int)1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), ProxyRegistry.newStack((Block)marble, (int)1, (int)0)});
        }
        if (enableLimestone) {
            limestone = new BlockLimestone();
            if (this.enableStairsAndSlabs) {
                BlockModSlab.initSlab((Block)limestone, (int)0, (BlockModSlab)new BlockLimestoneSlab(false), (BlockModSlab)new BlockLimestoneSlab(true));
                BlockModStairs.initStairs((Block)limestone, (int)0, (BlockStairs)new BlockLimestoneStairs());
            }
            VanillaWalls.add("limestone", (Block)limestone, 0, this.enableWalls);
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)limestone, (int)4, (int)1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), ProxyRegistry.newStack((Block)limestone, (int)1, (int)0)});
        }
        IBlockState graniteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
        IBlockState dioriteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
        IBlockState andesiteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        generators = new ArrayList<StoneInfoBasedGenerator>();
        generators.add(new StoneInfoBasedGenerator(() -> graniteInfo, graniteState, "granite"));
        generators.add(new StoneInfoBasedGenerator(() -> dioriteInfo, dioriteState, "diorite"));
        generators.add(new StoneInfoBasedGenerator(() -> andesiteInfo, andesiteState, "andesite"));
        if (enableMarble) {
            generators.add(new StoneInfoBasedGenerator(() -> marbleInfo, marble.func_176223_P(), "marble"));
        }
        if (enableLimestone) {
            generators.add(new StoneInfoBasedGenerator(() -> limestoneInfo, limestone.func_176223_P(), "limestone"));
        }
        if (this.outputCSV) {
            BiomeTypeConfigHandler.debugStoneGeneration(generators);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (enableMarble) {
            OreDictionary.registerOre((String)"stoneMarble", (ItemStack)ProxyRegistry.newStack((Block)marble, (int)1, (int)0));
            OreDictionary.registerOre((String)"stoneMarblePolished", (ItemStack)ProxyRegistry.newStack((Block)marble, (int)1, (int)1));
            ModIntegrationHandler.registerChiselVariant("marble", ProxyRegistry.newStack((Block)marble, (int)1, (int)0));
            ModIntegrationHandler.registerChiselVariant("marble", ProxyRegistry.newStack((Block)marble, (int)1, (int)1));
        }
        if (enableLimestone) {
            OreDictionary.registerOre((String)"stoneLimestone", (ItemStack)ProxyRegistry.newStack((Block)limestone, (int)1, (int)0));
            OreDictionary.registerOre((String)"stoneLimestonePolished", (ItemStack)ProxyRegistry.newStack((Block)limestone, (int)1, (int)1));
            ModIntegrationHandler.registerChiselVariant("limestone", ProxyRegistry.newStack((Block)limestone, (int)1, (int)0));
            ModIntegrationHandler.registerChiselVariant("limestone", ProxyRegistry.newStack((Block)limestone, (int)1, (int)1));
        }
    }

    @SubscribeEvent
    public void onOreGenerate(OreGenEvent.GenerateMinable event) {
        switch (event.getType()) {
            case GRANITE: {
                if (!RevampStoneGen.graniteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case DIORITE: {
                if (!RevampStoneGen.dioriteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case ANDESITE: {
                if (RevampStoneGen.andesiteInfo.enabled) {
                    event.setResult(Event.Result.DENY);
                }
                this.generateNewStones(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void generateNewStones(OreGenEvent.GenerateMinable event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Chunk chunk = world.func_175726_f(pos);
        for (StoneInfoBasedGenerator gen : generators) {
            gen.generate(chunk.field_76635_g, chunk.field_76647_h, world);
        }
    }

    @Override
    public boolean hasOreGenSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class StoneInfo {
        public final boolean enabled;
        public final int clusterSize;
        public final int clusterRarity;
        public final int upperBound;
        public final int lowerBound;
        public final boolean clustersRarityPerChunk;
        public final DimensionConfig dims;
        public final List<BiomeDictionary.Type> allowedBiomes;

        private StoneInfo(String category, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled, String dimStr, BiomeDictionary.Type ... biomes) {
            this.enabled = ModuleLoader.config.getBoolean("Enabled", category, true, "") && enabled;
            this.clusterSize = ModuleLoader.config.getInt("Cluster Radius", category, clusterSize, 0, Integer.MAX_VALUE, "");
            this.clusterRarity = ModuleLoader.config.getInt("Cluster Rarity", category, clusterRarity, 0, Integer.MAX_VALUE, "Out of how many chunks would one of these clusters generate");
            this.upperBound = ModuleLoader.config.getInt("Y Level Max", category, upperBound, 0, 255, "");
            this.lowerBound = ModuleLoader.config.getInt("Y Level Min", category, lowerBound, 0, 255, "");
            this.clustersRarityPerChunk = ModuleLoader.config.getBoolean("Invert Cluster Rarity", category, false, "Setting this to true will make the 'Cluster Rarity' feature be X per chunk rather than 1 per X chunks");
            this.dims = new DimensionConfig(category, dimStr);
            this.allowedBiomes = BiomeTypeConfigHandler.parseBiomeTypeArrayConfig("Allowed Biome Types", category, biomes);
        }
    }
}

