/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DungeonTweaksCompat {
    public static boolean isLegacy = false;
    public static boolean isLoaded = false;
    public static final ResourceLocation quark = new ResourceLocation("quark:dungeon");

    public static void legacyCheck() {
        isLoaded = Loader.isModLoaded((String)"dungeontweaks");
        if (!isLoaded) {
            return;
        }
        try {
            Class<?> c = Class.forName("com.EvilNotch.dungeontweeks.main.Events.EventDungeon$Post");
            isLegacy = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void registerDungeons() {
        if (!isLoaded || isLegacy) {
            return;
        }
        try {
            Class<?> dungeonMobs = Class.forName("com.evilnotch.dungeontweeks.main.world.worldgen.mobs.DungeonMobs");
            Method cacheForge = dungeonMobs.getMethod("cacheForge", new Class[0]);
            cacheForge.invoke(null, new Object[0]);
            Method addDungeonMob = dungeonMobs.getMethod("addDungeonMob", ResourceLocation.class, DungeonHooks.DungeonMob.class);
            Method getDungeonList = dungeonMobs.getMethod("getDungeonList", ResourceLocation.class, Boolean.TYPE);
            List list = (List)getDungeonList.invoke(null, new ResourceLocation("dungeon"), true);
            for (DungeonHooks.DungeonMob mob : list) {
                addDungeonMob.invoke(null, quark, mob);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fireDungeonSpawn(TileEntity tile, World world, Random random) {
        if (isLegacy) {
            try {
                Constructor<?> constructor = Class.forName("com.EvilNotch.dungeontweeks.main.Events.EventDungeon$Post").getConstructor(TileEntity.class, BlockPos.class, Random.class, ResourceLocation.class, World.class);
                Event event = (Event)constructor.newInstance(tile, tile.func_174877_v(), random, quark, world);
                MinecraftForge.EVENT_BUS.post(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                Method fireDungeonTweaks = Class.forName("com.evilnotch.dungeontweeks.main.world.worldgen.mobs.DungeonMobs").getMethod("fireDungeonTweaks", ResourceLocation.class, TileEntity.class, Random.class, World.class);
                fireDungeonTweaks.invoke(null, quark, tile, random, world);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

