/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemModArmor;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.oddities.client.model.ModelBackpack;
import vazkii.quark.oddities.feature.Backpacks;

public class ItemBackpack
extends ItemModArmor
implements IQuarkItem,
IItemColorProvider {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    @SideOnly(value=Side.CLIENT)
    public static ModelBiped model;

    public ItemBackpack() {
        super("backpack", ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_185043_a(new ResourceLocation("has_items"), (stack, world, entity) -> !Backpacks.superOpMode && ItemBackpack.doesBackpackHaveItems(stack) ? 1.0f : 0.0f);
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean hasItems = !Backpacks.superOpMode && ItemBackpack.doesBackpackHaveItems(stack);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.field_190941_k);
        boolean changedEnchants = false;
        if (hasItems) {
            if (Backpacks.isEntityWearingBackpack(entityIn)) {
                if (!isCursed) {
                    enchants.put(Enchantments.field_190941_k, 1);
                    changedEnchants = true;
                }
            } else {
                ItemStack copy = stack.func_77946_l();
                stack.func_190920_e(0);
                entityIn.func_70099_a(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.remove(Enchantments.field_190941_k);
            changedEnchants = true;
        }
        if (changedEnchants) {
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (Backpacks.superOpMode || entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack stack = entityItem.func_92059_d();
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack copy = stackAt.func_77946_l();
            stackAt.func_190920_e(0);
            InventoryHelper.func_180173_a((World)entityItem.field_70170_p, (double)entityItem.field_70165_t, (double)entityItem.field_70163_u, (double)entityItem.field_70161_v, (ItemStack)copy);
        }
        return false;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return type != null && type.equals("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (model == null) {
            model = new ModelBackpack();
        }
        return model;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        return new InvProvider();
    }

    public IItemColor getItemColor() {
        return (stack, i) -> i == 1 ? ((ItemArmor)stack.func_77973_b()).func_82814_b(stack) : -1;
    }

    private static class InvProvider
    implements ICapabilitySerializable<NBTBase> {
        private final IItemHandler inv = new ItemStackHandler(27){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack toInsert, boolean simulate) {
                return super.insertItem(slot, toInsert, simulate);
            }
        };

        private InvProvider() {
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, nbt);
        }
    }
}

