/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.item;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.IQuarkItem;

public class ItemTrowel
extends ItemMod
implements IQuarkItem {
    private static final String TAG_PLACING_SEED = "placing_seed";
    private static final String TAG_LAST_STACK = "last_stack";

    public ItemTrowel(int durability) {
        super("trowel", new String[0]);
        this.func_77625_d(1);
        this.func_77656_e(durability);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ArrayList<ItemStack> targets = new ArrayList<ItemStack>();
        for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) continue;
            targets.add(stack);
        }
        ItemStack ourStack = player.func_184586_b(hand);
        if (targets.isEmpty()) {
            return EnumActionResult.PASS;
        }
        long seed = ItemNBTHelper.getLong((ItemStack)ourStack, (String)TAG_PLACING_SEED, (long)0L);
        Random rand = new Random(seed);
        ItemNBTHelper.setLong((ItemStack)ourStack, (String)TAG_PLACING_SEED, (long)rand.nextLong());
        ItemStack target = (ItemStack)targets.get(rand.nextInt(targets.size()));
        EnumActionResult result = this.placeBlock(target, player, pos, facing, worldIn, hand, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS) {
            NBTTagCompound cmp = new NBTTagCompound();
            target.func_77955_b(cmp);
            ItemNBTHelper.setCompound((ItemStack)ourStack, (String)TAG_LAST_STACK, (NBTTagCompound)cmp);
            if (ourStack.func_77984_f()) {
                ourStack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        return result;
    }

    private EnumActionResult placeBlock(ItemStack itemstack, EntityPlayer player, BlockPos pos, EnumFacing facing, World worldIn, EnumHand hand, float hitX, float hitY, float hitZ) {
        IBlockState stateAt = worldIn.func_180495_p(pos);
        if (!stateAt.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (itemstack.func_77973_b() instanceof ItemBlock) {
            ItemBlock item = (ItemBlock)itemstack.func_77973_b();
            Block block = item.func_179223_d();
            if (player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(block, pos, false, facing, null)) {
                int i = item.func_77647_b(itemstack.func_77960_j());
                IBlockState state = block.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
                if (item.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, state)) {
                    state = worldIn.func_180495_p(pos);
                    SoundType soundtype = state.func_177230_c().getSoundType(state, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.shrinkInventory(itemstack, player);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    private void shrinkInventory(ItemStack stack, EntityPlayer player) {
        int i;
        EntityPlayer entityPlayer = player;
        for (i = (v22014).field_71071_by.func_70451_h(); i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!this.shrinkItem(stack, player, i)) continue;
            return;
        }
        i = 0;
        while (true) {
            EntityPlayer entityPlayer2 = player;
            if (i >= entityPlayer2.field_71071_by.func_70451_h()) break;
            if (this.shrinkItem(stack, player, i)) {
                return;
            }
            ++i;
        }
    }

    private boolean shrinkItem(ItemStack stack, EntityPlayer player, int slot) {
        ItemStack stackAt = player.field_71071_by.func_70301_a(slot);
        if (stack.func_77969_a(stackAt) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackAt)) {
            stackAt.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static ItemStack getLastStack(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_LAST_STACK, (boolean)false);
        return new ItemStack(cmp);
    }
}

