/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import tschipp.extraambiance.block.BlockParticleEmitterAdvanced;

public class TileEntitySoundEmitter
extends TileEntity
implements ITickable {
    public String soundName = "block.dispenser.launch";
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public boolean useRandomVolume = false;
    public boolean useRandomPitch = true;
    public double spawnX = 0.0;
    public double spawnY = 0.0;
    public double spawnZ = 0.0;
    public int spawnTime = 60;
    public boolean needsPower = false;
    private Random rand = new Random();
    private int timer = 0;

    public void func_73660_a() {
        if (this.timer >= this.spawnTime) {
            this.makeSound();
            this.timer = 0;
        }
        ++this.timer;
    }

    private void makeSound() {
        SoundEvent sound;
        if ((!this.needsPower || ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockParticleEmitterAdvanced.POWERED)).booleanValue()) && (sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(this.soundName))) != null) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + this.spawnX, (double)this.field_174879_c.func_177956_o() + this.spawnY, (double)this.field_174879_c.func_177952_p() + this.spawnZ, sound, SoundCategory.BLOCKS, (float)((double)this.volume + (this.useRandomVolume ? this.rand.nextGaussian() * 0.3 : 0.0)), (float)((double)this.pitch + (this.useRandomPitch ? this.rand.nextGaussian() * 0.3 : 0.0)), true);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound sound = new NBTTagCompound();
        sound.func_74780_a("spawnX", this.spawnX);
        sound.func_74780_a("spawnY", this.spawnY);
        sound.func_74780_a("spawnZ", this.spawnZ);
        sound.func_74778_a("soundName", this.soundName);
        sound.func_74768_a("spawnTime", this.spawnTime);
        sound.func_74776_a("volume", this.volume);
        sound.func_74776_a("pitch", this.pitch);
        sound.func_74757_a("useRandomVolume", this.useRandomVolume);
        sound.func_74757_a("useRandomPitch", this.useRandomPitch);
        sound.func_74768_a("timer", this.timer);
        sound.func_74757_a("needsPower", this.needsPower);
        compound.func_74782_a("toSaveLightData", (NBTBase)sound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound sound = compound.func_74775_l("toSaveLightData");
        this.readSoundData(sound);
    }

    private void readSoundData(NBTTagCompound sound) {
        this.spawnX = sound.func_74769_h("spawnX");
        this.spawnY = sound.func_74769_h("spawnY");
        this.spawnZ = sound.func_74769_h("spawnZ");
        this.soundName = sound.func_74779_i("soundName");
        this.spawnTime = sound.func_74762_e("spawnTime");
        this.volume = sound.func_74760_g("volume");
        this.pitch = sound.func_74760_g("pitch");
        this.useRandomVolume = sound.func_74767_n("useRandomVolume");
        this.useRandomPitch = sound.func_74767_n("useRandomPitch");
        this.timer = sound.func_74762_e("timer");
        this.needsPower = sound.func_74767_n("needsPower");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

