/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.block.BlockParticleEmitterAdvanced;
import tschipp.tschipplib.helper.ColorHelper;
import tschipp.tschipplib.helper.ItemHelper;

public class TileEntityParticleEmitter
extends TileEntity
implements ITickable {
    public String particleName = "flame";
    public double spawnX = 0.0;
    public double spawnY = 0.0;
    public double spawnZ = 0.0;
    public double spawnRadiusX = 0.25;
    public double spawnRadiusY = 0.25;
    public double spawnRadiusZ = 0.25;
    public double motionX = 0.0;
    public double motionY = 0.0;
    public double motionZ = 0.0;
    public boolean randomMotion = false;
    public int r = 255;
    public int g = 255;
    public int b = 255;
    public boolean changeColors = false;
    public float colorChangeAmount = 0.075f;
    public String particleTexture = "minecraft:blocks/stone";
    public String arguments = "minecraft:stone;0";
    public boolean ignoreRange = false;
    public int spawnTime = 60;
    public int spawnCount = 5;
    public float particleSize = 1.0f;
    public int particleMaxAge = 0;
    public boolean needsPower = false;
    private Random rand = new Random();
    public int timer = 0;
    private float[] rgb;
    public boolean useParticleTexture = false;

    public void func_73660_a() {
        this.rgb = ColorHelper.getRGB((int[])new int[]{this.r, this.g, this.b});
        this.useParticleTexture = this.particleName.equals("customTexture");
        if (this.timer >= this.spawnTime) {
            for (int i = 0; i < this.spawnCount; ++i) {
                this.spawnParticle();
            }
            this.timer = 0;
        }
        ++this.timer;
    }

    private void spawnParticle() {
        if (this.field_145850_b.field_72995_K && (!this.needsPower || ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockParticleEmitterAdvanced.POWERED)).booleanValue())) {
            Particle particle = null;
            EnumParticleTypes type = EnumParticleTypes.func_186831_a((String)this.particleName);
            if (type != null) {
                int id = type.func_179348_c();
                int arg = type.func_179345_d();
                if (arg == 0) {
                    particle = EA.proxy.spawnVanillaParticle(id, this.ignoreRange, false, (double)this.field_174879_c.func_177958_n() + 0.5 + this.spawnX + this.rand.nextGaussian() * this.spawnRadiusX, (double)this.field_174879_c.func_177956_o() + 0.5 + this.spawnY + this.rand.nextGaussian() * this.spawnRadiusY, (double)this.field_174879_c.func_177952_p() + 0.5 + this.spawnZ + this.rand.nextGaussian() * this.spawnRadiusZ, this.motionX * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionY * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionZ * (this.randomMotion ? this.rand.nextGaussian() : 1.0), new int[0]);
                } else if (arg == 1) {
                    particle = EA.proxy.spawnVanillaParticle(id, this.ignoreRange, false, (double)this.field_174879_c.func_177958_n() + 0.5 + this.spawnX + this.rand.nextGaussian() * this.spawnRadiusX, (double)this.field_174879_c.func_177956_o() + 0.5 + this.spawnY + this.rand.nextGaussian() * this.spawnRadiusY, (double)this.field_174879_c.func_177952_p() + 0.5 + this.spawnZ + this.rand.nextGaussian() * this.spawnRadiusZ, this.motionX * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionY * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionZ * (this.randomMotion ? this.rand.nextGaussian() : 1.0), Block.func_176210_f((IBlockState)ItemHelper.getBlockStateFromString((String)this.arguments)));
                } else if (arg == 2) {
                    particle = EA.proxy.spawnVanillaParticle(id, this.ignoreRange, false, (double)this.field_174879_c.func_177958_n() + 0.5 + this.spawnX + this.rand.nextGaussian() * this.spawnRadiusX, (double)this.field_174879_c.func_177956_o() + 0.5 + this.spawnY + this.rand.nextGaussian() * this.spawnRadiusY, (double)this.field_174879_c.func_177952_p() + 0.5 + this.spawnZ + this.rand.nextGaussian() * this.spawnRadiusZ, this.motionX * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionY * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionZ * (this.randomMotion ? this.rand.nextGaussian() : 1.0), Item.func_150891_b((Item)ItemHelper.getItemFromString((String)this.arguments)), ItemHelper.getMetaFromString((String)this.arguments));
                }
            } else if (this.useParticleTexture) {
                particle = EA.proxy.getCustomTextureParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + this.spawnX + this.rand.nextGaussian() * this.spawnRadiusX, (double)this.field_174879_c.func_177956_o() + 0.5 + this.spawnY + this.rand.nextGaussian() * this.spawnRadiusY, (double)this.field_174879_c.func_177952_p() + 0.5 + this.spawnZ + this.rand.nextGaussian() * this.spawnRadiusZ, this.motionX * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionY * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.motionZ * (this.randomMotion ? this.rand.nextGaussian() : 1.0), this.ignoreRange);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
            }
            if (particle != null) {
                if (this.changeColors) {
                    this.rgb = ColorHelper.changeBrightness((float)((float)(this.rand.nextGaussian() * (double)this.colorChangeAmount)), (float[])this.rgb);
                    particle.func_70538_b(this.rgb[0], this.rgb[1], this.rgb[2]);
                }
                if (this.particleMaxAge != 0) {
                    particle.func_187114_a(this.particleMaxAge);
                }
                if (this.useParticleTexture) {
                    TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.particleTexture);
                    particle.func_187117_a(sprite);
                }
                particle.func_70541_f(this.particleSize);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound particle = new NBTTagCompound();
        particle.func_74780_a("spawnX", this.spawnX);
        particle.func_74780_a("spawnY", this.spawnY);
        particle.func_74780_a("spawnZ", this.spawnZ);
        particle.func_74780_a("spawnRadiusX", this.spawnRadiusX);
        particle.func_74780_a("spawnRadiusY", this.spawnRadiusY);
        particle.func_74780_a("spawnRadiusZ", this.spawnRadiusZ);
        particle.func_74780_a("motionX", this.motionX);
        particle.func_74780_a("motionY", this.motionY);
        particle.func_74780_a("motionZ", this.motionZ);
        particle.func_74768_a("red", this.r);
        particle.func_74768_a("green", this.g);
        particle.func_74768_a("blue", this.b);
        particle.func_74778_a("particleName", this.particleName);
        particle.func_74768_a("spawnTime", this.spawnTime);
        particle.func_74768_a("spawnCount", this.spawnCount);
        particle.func_74776_a("particleSize", this.particleSize);
        particle.func_74776_a("colorChangeAmount", this.colorChangeAmount);
        particle.func_74757_a("changeColors", this.changeColors);
        particle.func_74778_a("particleTexture", this.particleTexture);
        particle.func_74768_a("particleMaxAge", this.particleMaxAge);
        particle.func_74757_a("randomMotion", this.randomMotion);
        particle.func_74768_a("timer", this.timer);
        particle.func_74757_a("needsPower", this.needsPower);
        particle.func_74778_a("arguments", this.arguments);
        particle.func_74757_a("ignoreRange", this.ignoreRange);
        compound.func_74782_a("toSaveLightData", (NBTBase)particle);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound particle = compound.func_74775_l("toSaveLightData");
        this.readParticleData(particle);
    }

    public void readParticleData(NBTTagCompound particle) {
        this.spawnX = particle.func_74769_h("spawnX");
        this.spawnY = particle.func_74769_h("spawnY");
        this.spawnZ = particle.func_74769_h("spawnZ");
        this.spawnRadiusX = particle.func_74769_h("spawnRadiusX");
        this.spawnRadiusY = particle.func_74769_h("spawnRadiusY");
        this.spawnRadiusZ = particle.func_74769_h("spawnRadiusZ");
        this.motionX = particle.func_74769_h("motionX");
        this.motionY = particle.func_74769_h("motionY");
        this.motionZ = particle.func_74769_h("motionZ");
        this.r = particle.func_74762_e("red");
        this.g = particle.func_74762_e("green");
        this.b = particle.func_74762_e("blue");
        this.particleName = particle.func_74779_i("particleName");
        this.spawnTime = particle.func_74762_e("spawnTime");
        this.spawnCount = particle.func_74762_e("spawnCount");
        this.particleSize = particle.func_74760_g("particleSize");
        this.colorChangeAmount = particle.func_74760_g("colorChangeAmount");
        this.particleTexture = particle.func_74779_i("particleTexture");
        this.changeColors = particle.func_74767_n("changeColors");
        this.particleMaxAge = particle.func_74762_e("particleMaxAge");
        this.randomMotion = particle.func_74767_n("randomMotion");
        this.timer = particle.func_74762_e("timer");
        this.needsPower = particle.func_74767_n("needsPower");
        this.arguments = particle.func_74779_i("arguments");
        this.ignoreRange = particle.func_74767_n("ignoreRange");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean usesArguments() {
        EnumParticleTypes type = EnumParticleTypes.func_186831_a((String)this.particleName);
        if (type != null) {
            return type.func_179345_d() > 0;
        }
        return false;
    }
}

