/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.event;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tschipp.extraambiance.api.ILight;
import tschipp.extraambiance.api.ILightEditor;
import tschipp.extraambiance.api.ILightViewer;
import tschipp.extraambiance.api.LightData;
import tschipp.tschipplib.helper.ItemStackHelper;
import tschipp.tschipplib.helper.RayHelper;

public class LightEvents {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockRender(DrawBlockHighlightEvent event) {
        RayTraceResult ray = event.getTarget();
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ray.func_178782_a();
            Block block = event.getPlayer().field_70170_p.func_180495_p(pos).func_177230_c();
            ItemStack held = event.getPlayer().func_184614_ca();
            ItemStack off = event.getPlayer().func_184592_cb();
            if (block instanceof ILight) {
                if (held.func_190926_b() && off.func_190926_b()) {
                    event.setCanceled(true);
                    return;
                }
                if (ItemStackHelper.hasItemHeld(ILightViewer.class, (EntityPlayer)event.getPlayer())) {
                    if (ItemStackHelper.hasItemHeld(ILightEditor.class, (EntityPlayer)event.getPlayer())) {
                        ((ILight)block).onHover(event.getPlayer(), pos, ItemStackHelper.getHandForType(ILightEditor.class, (EntityPlayer)event.getPlayer()), true);
                        return;
                    }
                    ((ILight)block).onHover(event.getPlayer(), pos, ItemStackHelper.getHandForType(ILightViewer.class, (EntityPlayer)event.getPlayer()), false);
                    return;
                }
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        IBlockState state = event.getState();
        if (player != null && state != null && ItemStackHelper.hasTypeInHand(ILightEditor.class, (EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND) && state.func_177230_c() instanceof ILight) {
            ILightEditor editer = (ILightEditor)player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            editer.onLightBreak((ILight)state.func_177230_c(), player, event.getPos(), EnumHand.MAIN_HAND);
            event.setCanceled(true);
            event.getWorld().func_175698_g(event.getPos());
        }
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EnumHand hand = event.getHand();
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (ItemStackHelper.hasTypeInHand(ILightEditor.class, (EntityPlayer)player, (EnumHand)hand) && player.func_70093_af() && block instanceof ILight) {
            Item item = event.getItemStack().func_77973_b();
            ((ILightEditor)item).onShiftRightClickLight((ILight)block, player, event.getPos(), event.getItemStack(), hand);
        }
        if (hand == EnumHand.OFF_HAND && ItemStackHelper.hasTypeInHand(ILightEditor.class, (EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND) && player.func_70093_af() && LightData.isDataCompatible(player.func_184614_ca(), block)) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onRightClickAir(PlayerInteractEvent.RightClickItem event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EnumHand hand = event.getHand();
        RayTraceResult ray = RayHelper.rayTrace((EntityPlayer)player, (double)4.5);
        if ((ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) && ItemStackHelper.hasTypeInHand(ILightEditor.class, (EntityPlayer)player, (EnumHand)hand) && player.func_70093_af()) {
            Item item = player.func_184586_b(hand).func_77973_b();
            ((ILightEditor)item).onShiftRightClickAir(player, hand);
        }
    }
}

