/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.api.LightData;
import tschipp.extraambiance.block.BlockLightBase;
import tschipp.tschipplib.block.IMetaBlockName;

public class BlockSoundEmitterSimple
extends BlockLightBase
implements IMetaBlockName {
    private boolean light;
    public static final PropertyEnum<EnumType> SOUND = PropertyEnum.func_177709_a((String)"sound", EnumType.class);

    public BlockSoundEmitterSimple(boolean light) {
        super("sound_emitter" + (light ? "_light" : ""));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SOUND, (Comparable)((Object)EnumType.BLOCK_FURNACE_FIRE_CRACKLE)));
        this.light = light;
    }

    public int func_149750_m(IBlockState state) {
        return this.light ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        if (itemIn == EA.extraambiance) {
            for (EnumType type : EnumType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SOUND, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(SOUND))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SOUND});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int meta = stack.func_77960_j();
        worldIn.func_175656_a(pos, this.func_176203_a(meta));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public Particle getViewingParticle(World world, IBlockState state, BlockPos pos, Random rand) {
        return EA.proxy.getLightParticle(world, pos, 0.065f, 0.035f, 0.3725f, 1.0f);
    }

    @Override
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((double)rand.nextFloat() < 0.2) {
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((EnumType)((Object)stateIn.func_177229_b(SOUND))).getSound(), SoundCategory.BLOCKS, (float)(1.0 + rand.nextGaussian() * 0.2), (float)(1.0 + rand.nextGaussian() * 0.2), true);
        }
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public String getSpecialName(ItemStack stack) {
        return ((EnumType)((Object)this.func_176203_a(stack.func_77960_j()).func_177229_b(SOUND))).func_176610_l();
    }

    @Override
    public void onHover(EntityPlayer player, BlockPos pos, EnumHand hand, boolean editer) {
        ItemStack stack = player.func_184586_b(hand);
        if (editer) {
            LightData light = LightData.getLightDataFromStack(stack);
            if (light != null) {
                if (light.isDataCompatible((Block)this)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_74838_a((String)"text.lighteditor.compatible") + TextFormatting.RESET + " Sound: " + I18n.func_74838_a((String)("sound." + ((EnumType)((Object)player.field_70170_p.func_180495_p(pos).func_177229_b(SOUND))).func_176610_l()))), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"text.lighteditor.incompatible") + TextFormatting.RESET + " Sound: " + I18n.func_74838_a((String)("sound." + ((EnumType)((Object)player.field_70170_p.func_180495_p(pos).func_177229_b(SOUND))).func_176610_l()))), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("Sound: " + I18n.func_74838_a((String)("sound." + ((EnumType)((Object)player.field_70170_p.func_180495_p(pos).func_177229_b(SOUND))).func_176610_l()))), true);
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        BLOCK_FURNACE_FIRE_CRACKLE(0, SoundEvents.field_187652_bv),
        BLOCK_LAVA_POP(1, SoundEvents.field_187662_cZ),
        ENTITY_ARROW_HIT_PLAYER(2, SoundEvents.field_187734_u),
        ENTITY_CREEPER_PRIMED(3, SoundEvents.field_187572_ar),
        ENTITY_ENDERDRAGON_GROWL(4, SoundEvents.field_187525_aO),
        ENTITY_ENDERMEN_DEATH(5, SoundEvents.field_187530_aT),
        ENTITY_ENDERMEN_STARE(6, SoundEvents.field_187533_aW),
        ENTITY_GENERIC_EXPLODE(7, SoundEvents.field_187539_bB),
        ENTITY_GHAST_SCREAM(8, SoundEvents.field_189105_bM),
        ENTITY_LLAMA_SPIT(9, SoundEvents.field_191255_dF),
        ENTITY_LIGHTNING_THUNDER(10, SoundEvents.field_187754_de),
        ENTITY_PLAYER_LEVELUP(11, SoundEvents.field_187802_ec),
        ENTITY_SHULKER_AMBIENT(12, SoundEvents.field_187773_eO),
        ENTITY_SKELETON_AMBIENT(13, SoundEvents.field_187854_fc),
        ENTITY_WITHER_AMBIENT(14, SoundEvents.field_187925_gy),
        EVOCATION_ILLAGER_PREPARE_WOLOLO(15, SoundEvents.field_191249_bs);

        private static final EnumType[] META;
        private final int meta;
        private final SoundEvent sound;

        private EnumType(int meta, SoundEvent sound) {
            this.meta = meta;
            this.sound = sound;
        }

        public int getMetadata() {
            return this.meta;
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META.length) {
                meta = 0;
            }
            return META[meta];
        }

        public String func_176610_l() {
            return ForgeRegistries.SOUND_EVENTS.getKey((IForgeRegistryEntry)this.sound).toString().replace(".", "_").replace("minecraft:", "");
        }

        static {
            META = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

