/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.api.ILightEditor;
import tschipp.extraambiance.api.LightData;
import tschipp.extraambiance.block.BlockLightBase;
import tschipp.extraambiance.handler.ItemHandler;
import tschipp.extraambiance.tileentity.TileEntitySoundEmitter;
import tschipp.tschipplib.helper.ItemStackHelper;

public class BlockSoundEmitterAdvanced
extends BlockLightBase
implements ITileEntityProvider {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockSoundEmitterAdvanced() {
        super("sound_emitter_advanced");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.field_149758_A = true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySoundEmitter();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)POWERED) == Boolean.valueOf(false) ? 0 : 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && !this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!worldIn.func_175640_z(pos) && this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && !this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!worldIn.func_175640_z(pos) && this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public Particle getViewingParticle(World world, IBlockState state, BlockPos pos, Random rand) {
        return EA.proxy.getLightParticle(world, pos, 0.1f, 0.78f, 0.0f, 1.0f);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        LightData lightData = LightData.getLightDataFromStack(stack);
        if (lightData != null) {
            lightData.apply(worldIn, pos);
        }
    }

    @Override
    public void onShiftRightClick(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumHand hand) {
        LightData lightData = LightData.getLightData(world, pos);
        if (lightData != null) {
            lightData.saveToStack(stack);
        }
    }

    @Override
    public void onHover(EntityPlayer player, BlockPos pos, EnumHand hand, boolean editer) {
        LightData light;
        ItemStack stack = player.func_184586_b(hand);
        if (editer && (light = LightData.getLightDataFromStack(stack)) != null) {
            if (light.isDataCompatible((Block)this)) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_74838_a((String)"text.lighteditor.compatible")), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"text.lighteditor.incompatible")), true);
            }
        }
    }

    @Override
    public void onBreak(EntityPlayer player, World world, BlockPos pos) {
        LightData lightData = LightData.getLightData(world, pos);
        ItemStack drop = new ItemStack((Item)ItemHandler.soundEmitterAdvanced);
        lightData.getNbt().func_74768_a("timer", 0);
        lightData.saveToStack(drop);
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumHand hand1;
        if (ItemStackHelper.hasItemHeld(ILightEditor.class, (EntityPlayer)playerIn) && (hand1 = ItemStackHelper.getHandForType(ILightEditor.class, (EntityPlayer)playerIn)) == hand) {
            playerIn.openGui((Object)EA.instance, 4, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            Item item = playerIn.func_184586_b(hand1).func_77973_b();
            ((ILightEditor)item).onLightEdit(playerIn, pos, hand1);
            return true;
        }
        return false;
    }
}

