/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.block.BlockLightBase;
import tschipp.tschipplib.block.IMetaBlockName;

public class BlockParticleEmitterSimple
extends BlockLightBase
implements IMetaBlockName {
    private boolean light;
    public static final PropertyEnum<EnumType> PARTICLE = PropertyEnum.func_177709_a((String)"particle", EnumType.class);

    public BlockParticleEmitterSimple(boolean light) {
        super("particle_emitter" + (light ? "_light" : ""));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PARTICLE, (Comparable)((Object)EnumType.FLAME)));
        this.light = light;
    }

    public int func_149750_m(IBlockState state) {
        return this.light ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        if (itemIn == EA.extraambiance) {
            for (EnumType type : EnumType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PARTICLE, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(PARTICLE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PARTICLE});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int meta = stack.func_77960_j();
        worldIn.func_175656_a(pos, this.func_176203_a(meta));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        world.func_175688_a(((EnumType)((Object)state.func_177229_b(PARTICLE))).particle, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        super.func_180655_c(state, world, pos, rand);
    }

    @Override
    public Particle getViewingParticle(World world, IBlockState state, BlockPos pos, Random rand) {
        return EA.proxy.getLightParticle(world, pos, 0.065f, 0.2627f, 0.75f, 0.0f);
    }

    public String getSpecialName(ItemStack stack) {
        return ((EnumType)((Object)this.func_176203_a(stack.func_77960_j()).func_177229_b(PARTICLE))).func_176610_l();
    }

    public static enum EnumType implements IStringSerializable
    {
        FLAME(0, EnumParticleTypes.FLAME),
        SMOKE_LARGE(1, EnumParticleTypes.SMOKE_LARGE),
        CLOUD(2, EnumParticleTypes.CLOUD),
        ENCHANTMENT_TABLE(3, EnumParticleTypes.ENCHANTMENT_TABLE),
        CRIT_MAGIC(4, EnumParticleTypes.CRIT_MAGIC),
        END_ROD(5, EnumParticleTypes.END_ROD),
        EXPLOSION_LARGE(6, EnumParticleTypes.EXPLOSION_LARGE),
        FIREWORKS_SPARK(7, EnumParticleTypes.FIREWORKS_SPARK),
        HEART(8, EnumParticleTypes.HEART),
        LAVA(9, EnumParticleTypes.LAVA),
        NOTE(10, EnumParticleTypes.NOTE),
        PORTAL(11, EnumParticleTypes.PORTAL),
        REDSTONE(12, EnumParticleTypes.REDSTONE),
        TOTEM(13, EnumParticleTypes.TOTEM),
        VILLAGER_HAPPY(14, EnumParticleTypes.VILLAGER_HAPPY),
        DRAGON_BREATH(15, EnumParticleTypes.DRAGON_BREATH);

        private static final EnumType[] META;
        private final int meta;
        private final EnumParticleTypes particle;

        private EnumType(int meta, EnumParticleTypes particle) {
            this.meta = meta;
            this.particle = particle;
        }

        public int getMetadata() {
            return this.meta;
        }

        public EnumParticleTypes getParticle() {
            return this.particle;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META.length) {
                meta = 0;
            }
            return META[meta];
        }

        public String func_176610_l() {
            return this.particle.func_179346_b().toLowerCase();
        }

        static {
            META = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

