/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.block.BlockLightBase;

public class BlockLightRedstone
extends BlockLightBase {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private boolean inverted = false;

    public BlockLightRedstone(boolean inverted) {
        super("light_redstone" + (inverted ? "_inverted" : ""));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.inverted = inverted;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)POWERED) == Boolean.valueOf(false) ? 0 : 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public int func_149750_m(IBlockState state) {
        if (this.inverted) {
            return this.isPowered(state) ? 0 : 15;
        }
        return this.isPowered(state) ? 15 : 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && !this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!worldIn.func_175640_z(pos) && this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    @Override
    public Particle getViewingParticle(World world, IBlockState state, BlockPos pos, Random rand) {
        if (!this.inverted) {
            if (this.isPowered(state)) {
                return EA.proxy.getLightParticle(world, pos, 0.075f, 0.83529f, 0.1411764f, 0.0431372f);
            }
            return EA.proxy.getLightParticle(world, pos, 0.025f, 0.219f, 0.219f, 0.219f);
        }
        if (this.isPowered(state)) {
            return EA.proxy.getLightParticle(world, pos, 0.025f, 0.219f, 0.219f, 0.219f);
        }
        return EA.proxy.getLightParticle(world, pos, 0.075f, 0.83529f, 0.1411764f, 0.0431372f);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && !this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!worldIn.func_175640_z(pos) && this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

