/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.api.ILightEditor;
import tschipp.extraambiance.api.LightData;
import tschipp.extraambiance.block.BlockLightBase;
import tschipp.tschipplib.helper.ColorHelper;

public class BlockLightDimmableRedstone
extends BlockLightBase {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyInteger LIGHT = PropertyInteger.func_177719_a((String)"light", (int)0, (int)7);
    private boolean inverted;

    public BlockLightDimmableRedstone(boolean inverted) {
        super("light_dimmable_redstone" + (inverted ? "_inverted" : ""));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.inverted = inverted;
    }

    public IBlockState func_176203_a(int meta) {
        boolean flag = false;
        if (meta > 7) {
            meta -= 8;
            flag = true;
        }
        return this.func_176223_P().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag));
    }

    public int func_149750_m(IBlockState state) {
        return this.inverted ? (this.isPowered(state) ? 0 : (Integer)state.func_177229_b((IProperty)LIGHT)) * 2 : (this.isPowered(state) ? (Integer)state.func_177229_b((IProperty)LIGHT) : 0) * 2;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() instanceof ILightEditor) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)LIGHT));
            ((ILightEditor)playerIn.func_184586_b(hand).func_77973_b()).onLightEdit(playerIn, pos, hand);
            playerIn.func_146105_b((ITextComponent)new TextComponentString("Light: " + (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LIGHT) * 2), true);
            return true;
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT) + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIGHT, POWERED});
    }

    public boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && !this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!worldIn.func_175640_z(pos) && this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && !this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!worldIn.func_175640_z(pos) && this.isPowered(state)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public Particle getViewingParticle(World world, IBlockState state, BlockPos pos, Random rand) {
        float[] rgb = new float[3];
        rgb = !this.inverted ? (this.isPowered(state) ? new float[]{0.83529f, 0.1411764f, 0.0431372f} : new float[]{0.219f, 0.219f, 0.219f}) : (this.isPowered(state) ? new float[]{0.219f, 0.219f, 0.219f} : new float[]{0.83529f, 0.1411764f, 0.0431372f});
        rgb = ColorHelper.darker((float)(0.0589f * (float)(14 - (Integer)state.func_177229_b((IProperty)LIGHT) * 2)), (float[])rgb);
        return EA.proxy.getLightParticle(world, pos, 0.045f, rgb);
    }

    @Override
    public void onHover(EntityPlayer player, BlockPos pos, EnumHand hand, boolean editer) {
        ItemStack stack = player.func_184586_b(hand);
        if (editer) {
            LightData light = LightData.getLightDataFromStack(stack);
            if (light != null) {
                if (light.isDataCompatible((Block)this)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_74838_a((String)"text.lighteditor.compatible") + TextFormatting.RESET + " Light: " + (Integer)player.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LIGHT) * 2), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"text.lighteditor.incompatible") + TextFormatting.RESET + " Light: " + (Integer)player.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LIGHT) * 2), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("Light: " + (Integer)player.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LIGHT) * 2), true);
            }
        }
    }

    @Override
    public void onShiftRightClick(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumHand hand) {
        LightData lightData = LightData.getLightData(world, pos);
        if (lightData != null) {
            lightData.saveToStack(stack);
        }
    }
}

