/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import tschipp.extraambiance.EA;
import tschipp.extraambiance.api.ILightEditor;
import tschipp.extraambiance.api.LightData;
import tschipp.extraambiance.block.BlockLightBase;
import tschipp.tschipplib.helper.ColorHelper;

public class BlockLightDimmable
extends BlockLightBase {
    public static final PropertyInteger LIGHT = PropertyInteger.func_177719_a((String)"light", (int)0, (int)15);

    public BlockLightDimmable() {
        super("light_dimmable");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public BlockLightDimmable(String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIGHT});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() instanceof ILightEditor) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)LIGHT));
            ((ILightEditor)playerIn.func_184586_b(hand).func_77973_b()).onLightEdit(playerIn, pos, hand);
            playerIn.func_146105_b((ITextComponent)new TextComponentString("Light: " + worldIn.func_180495_p(pos).func_177229_b((IProperty)LIGHT)), true);
            return true;
        }
        return false;
    }

    public int func_149750_m(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT);
    }

    @Override
    public Particle getViewingParticle(World world, IBlockState state, BlockPos pos, Random rand) {
        float[] rgb = new float[]{0.929411f, 0.8862745f, 0.5098039f};
        rgb = ColorHelper.darker((float)(0.055f * (float)(15 - (Integer)state.func_177229_b((IProperty)LIGHT))), (float[])rgb);
        return EA.proxy.getLightParticle(world, pos, 0.045f, rgb);
    }

    @Override
    public void onHover(EntityPlayer player, BlockPos pos, EnumHand hand, boolean editer) {
        ItemStack stack = player.func_184586_b(hand);
        if (editer) {
            LightData light = LightData.getLightDataFromStack(stack);
            if (light != null) {
                if (light.isDataCompatible((Block)this)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_74838_a((String)"text.lighteditor.compatible") + TextFormatting.RESET + " Light: " + player.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LIGHT)), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"text.lighteditor.incompatible") + TextFormatting.RESET + " Light: " + player.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LIGHT)), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("Light: " + player.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LIGHT)), true);
            }
        }
    }

    @Override
    public void onShiftRightClick(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumHand hand) {
        LightData lightData = LightData.getLightData(world, pos);
        if (lightData != null) {
            lightData.saveToStack(stack);
        }
    }
}

