/*
 * Decompiled with CFR 0.152.
 */
package tschipp.extraambiance.api;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tschipp.extraambiance.api.ILight;

public class LightData {
    private IBlockState state;
    @Nullable
    private NBTTagCompound nbt;

    private LightData(IBlockState state, World world, BlockPos pos) {
        this.state = state;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            NBTTagCompound tag = new NBTTagCompound();
            if ((tag = tile.func_189515_b(tag)).func_74764_b("toSaveLightData")) {
                this.nbt = tag.func_74775_l("toSaveLightData");
            }
        }
    }

    private LightData(IBlockState state, NBTTagCompound tag) {
        this.state = state;
        this.nbt = tag;
    }

    @Nullable
    public static LightData getLightData(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof ILight)) {
            return null;
        }
        return new LightData(state, world, pos);
    }

    @Nullable
    public static LightData getLightDataFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!stack.func_77978_p().func_74764_b("lightData")) {
            return null;
        }
        NBTTagCompound lightData = stack.func_77978_p().func_74775_l("lightData");
        Block block = Block.func_149684_b((String)lightData.func_74779_i("block"));
        int meta = lightData.func_74762_e("meta");
        IBlockState state = block.func_176203_a(meta);
        NBTTagCompound toSync = lightData.func_74775_l("toSaveLightData");
        return new LightData(state, toSync);
    }

    public void saveToStack(ItemStack stack) {
        int meta = this.state.func_177230_c().func_176201_c(this.state);
        String name = this.state.func_177230_c().getRegistryName().toString();
        NBTTagCompound lightData = new NBTTagCompound();
        NBTTagCompound itemData = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        lightData.func_74768_a("meta", meta);
        lightData.func_74778_a("block", name);
        if (this.nbt != null && this.nbt != new NBTTagCompound()) {
            lightData.func_74782_a("toSaveLightData", (NBTBase)this.nbt);
        }
        itemData.func_74782_a("lightData", (NBTBase)lightData);
        stack.func_77982_d(itemData);
    }

    public boolean apply(World world, BlockPos pos) {
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        if (this.state.func_177230_c() != state.func_177230_c()) {
            return false;
        }
        world.func_175656_a(pos, this.state);
        state.func_177230_c().func_189540_a(this.state, world, pos, state.func_177230_c(), pos.func_177972_a(EnumFacing.UP));
        if (this.nbt != null && this.nbt != new NBTTagCompound() && (tile = world.func_175625_s(pos)) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_189515_b(tag);
            tag.func_74782_a("toSaveLightData", (NBTBase)this.nbt);
            tile.func_145839_a(tag);
        }
        return true;
    }

    public static void clearLightData(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        if (!stack.func_77978_p().func_74764_b("lightData")) {
            return;
        }
        stack.func_77978_p().func_82580_o("lightData");
    }

    public static boolean hasLightData(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("lightData");
    }

    public boolean isDataCompatible(Block block) {
        return this.state.func_177230_c() == block;
    }

    public static boolean isDataCompatible(ItemStack stack, Block block) {
        LightData light = LightData.getLightDataFromStack(stack);
        if (light == null) {
            return false;
        }
        return light.getState().func_177230_c() == block;
    }

    public IBlockState getState() {
        return this.state;
    }

    public NBTTagCompound getNbt() {
        return this.nbt;
    }
}

