/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.management;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.tiles.BigPostPostTile;
import gollorum.signpost.blocks.tiles.PostPostTile;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.modIntegration.SignpostAdapter;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.TeleportRequestMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BigBaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.MyBlockPosSet;
import gollorum.signpost.util.StonedHashSet;
import gollorum.signpost.util.StringSet;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.util.collections.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PostHandler {
    private static StonedHashSet allWaystones = new StonedHashSet();
    private static Lurchpaerchensauna<MyBlockPos, DoubleBaseInfo> posts = new Lurchpaerchensauna();
    private static Lurchpaerchensauna<MyBlockPos, BigBaseInfo> bigPosts = new Lurchpaerchensauna();
    public static Lurchpaerchensauna<UUID, TeleportInformation> awaiting = new Lurchpaerchensauna();
    public static Lurchpaerchensauna<UUID, StringSet> playerKnownWaystones = new Lurchpaerchensauna<UUID, StringSet>(){

        @Override
        public StringSet get(Object obj) {
            StringSet pair = (StringSet)super.get(obj);
            if (pair == null) {
                return this.put((UUID)obj, new StringSet());
            }
            return pair;
        }
    };
    public static Lurchpaerchensauna<UUID, Pair<MyBlockPosSet, Pair<Integer, Integer>>> playerKnownWaystonePositions = new Lurchpaerchensauna<UUID, Pair<MyBlockPosSet, Pair<Integer, Integer>>>(){

        @Override
        public Pair<MyBlockPosSet, Pair<Integer, Integer>> get(Object obj) {
            Pair pair = (Pair)super.get(obj);
            if (pair == null) {
                Pair p = new Pair();
                p.a = new MyBlockPosSet();
                p.b = new Pair();
                ((Pair)p.b).a = ClientConfigStorage.INSTANCE.getMaxWaystones();
                ((Pair)p.b).b = ClientConfigStorage.INSTANCE.getMaxSignposts();
                return this.put((UUID)obj, p);
            }
            return pair;
        }
    };

    public static boolean doesPlayerKnowWaystone(EntityPlayerMP player, BaseInfo waystone) {
        if (ClientConfigStorage.INSTANCE.isDisableDiscovery()) {
            return true;
        }
        return PostHandler.doesPlayerKnowNativeWaystone(player, waystone) || PostHandler.getPlayerKnownWaystones(player).contains(waystone);
    }

    public static boolean doesPlayerKnowNativeWaystone(EntityPlayerMP player, BaseInfo waystone) {
        if (ClientConfigStorage.INSTANCE.isDisableDiscovery()) {
            return true;
        }
        if (((MyBlockPosSet)PostHandler.playerKnownWaystonePositions.get((Object)player.func_110124_au()).a).contains(waystone.blockPos)) {
            if (playerKnownWaystones.containsKey(player)) {
                playerKnownWaystones.get(player.func_110124_au()).remove(waystone.getName());
            }
            return true;
        }
        return playerKnownWaystones.get(player.func_110124_au()).contains(waystone.getName());
    }

    public static void init() {
        allWaystones = new StonedHashSet();
        playerKnownWaystones = new Lurchpaerchensauna<UUID, StringSet>(){

            @Override
            public StringSet get(Object obj) {
                StringSet pair = (StringSet)super.get(obj);
                if (pair == null) {
                    return this.put((UUID)obj, new StringSet());
                }
                return pair;
            }
        };
        playerKnownWaystonePositions = new Lurchpaerchensauna<UUID, Pair<MyBlockPosSet, Pair<Integer, Integer>>>(){

            @Override
            public Pair<MyBlockPosSet, Pair<Integer, Integer>> get(Object obj) {
                Pair pair = (Pair)super.get(obj);
                if (pair == null) {
                    Pair p = new Pair();
                    p.a = new MyBlockPosSet();
                    p.b = new Pair();
                    ((Pair)p.b).a = ClientConfigStorage.INSTANCE.getMaxWaystones();
                    ((Pair)p.b).b = ClientConfigStorage.INSTANCE.getMaxSignposts();
                    return this.put((UUID)obj, p);
                }
                return pair;
            }
        };
        posts = new Lurchpaerchensauna();
        bigPosts = new Lurchpaerchensauna();
        awaiting = new Lurchpaerchensauna();
    }

    public static Lurchpaerchensauna<MyBlockPos, DoubleBaseInfo> getPosts() {
        return posts;
    }

    public static void setPosts(Lurchpaerchensauna<MyBlockPos, DoubleBaseInfo> posts) {
        PostHandler.posts = posts;
        PostHandler.refreshDoublePosts();
    }

    public static Lurchpaerchensauna<MyBlockPos, BigBaseInfo> getBigPosts() {
        return bigPosts;
    }

    public static void setBigPosts(Lurchpaerchensauna<MyBlockPos, BigBaseInfo> bigPosts) {
        PostHandler.bigPosts = bigPosts;
        PostHandler.refreshBigPosts();
    }

    private static void refreshPosts() {
        PostHandler.refreshDoublePosts();
        PostHandler.refreshBigPosts();
    }

    public static void refreshDoublePosts() {
        for (Map.Entry<MyBlockPos, DoubleBaseInfo> now : posts.entrySet()) {
            PostPostTile tile = (PostPostTile)now.getKey().getTile();
            if (tile == null) continue;
            tile.isWaystone();
            tile.getBases();
        }
    }

    public static void refreshBigPosts() {
        for (Map.Entry<MyBlockPos, BigBaseInfo> now : bigPosts.entrySet()) {
            BigPostPostTile tile = (BigPostPostTile)now.getKey().getTile();
            if (tile == null) continue;
            tile.isWaystone();
            tile.getBases();
        }
    }

    public static BaseInfo getWSbyName(String name) {
        if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            return new BaseInfo(name, null, null);
        }
        for (BaseInfo now : PostHandler.getAllWaystones()) {
            if (!name.equals(now.getName())) continue;
            return now;
        }
        return null;
    }

    public static BaseInfo getForceWSbyName(String name) {
        if (name == null || name.equals("null")) {
            return null;
        }
        for (BaseInfo now : PostHandler.getAllWaystones()) {
            if (!name.equals(now.getName())) continue;
            return now;
        }
        return new BaseInfo(name, null, null);
    }

    public static boolean pay(EntityPlayer player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (PostHandler.canPay(player, x1, y1, z1, x2, y2, z2)) {
            PostHandler.doPay(player, x1, y1, z1, x2, y2, z2);
            return true;
        }
        return false;
    }

    public static boolean canPay(EntityPlayer player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (ClientConfigStorage.INSTANCE.getCost() == null || ConfigHandler.isCreative(player)) {
            return true;
        }
        int playerItemCount = 0;
        for (ItemStack now : player.field_71071_by.field_70462_a) {
            if (now == null || now.func_77973_b() == null || now.func_77973_b().getClass() != ClientConfigStorage.INSTANCE.getCost().getClass()) continue;
            playerItemCount += now.func_190916_E();
        }
        return playerItemCount >= PostHandler.getStackSize(x1, y1, z1, x2, y2, z2);
    }

    public static void doPay(EntityPlayer player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (ClientConfigStorage.INSTANCE.getCost() == null || ConfigHandler.isCreative(player)) {
            return;
        }
        int stackSize = PostHandler.getStackSize(x1, y1, z1, x2, y2, z2);
        player.field_71071_by.func_174925_a(ClientConfigStorage.INSTANCE.getCost(), 0, stackSize, null);
    }

    public static int getStackSize(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (ClientConfigStorage.INSTANCE.getCostMult() == 0) {
            return 1;
        }
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return (int)Math.sqrt(dx * dx + dy * dy + dz * dz) / ClientConfigStorage.INSTANCE.getCostMult() + 1;
    }

    public static int getStackSize(MyBlockPos pos1, MyBlockPos pos2) {
        return PostHandler.getStackSize(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static void confirm(final EntityPlayerMP player) {
        final TeleportInformation info = awaiting.get(player.func_110124_au());
        SPEventHandler.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (info == null) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.noConfirm"), player);
                    return;
                }
                PostHandler.doPay((EntityPlayer)player, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, info.destination.pos.x, info.destination.pos.y + 1, info.destination.pos.z);
                SPEventHandler.cancelTask(info.boolRun);
                if (!player.func_71121_q().func_72912_H().func_76065_j().equals(info.world.func_72912_H().func_76065_j())) {
                    player.field_71133_b.func_184103_al().transferEntityToWorld((Entity)player, player.field_71093_bK, player.func_71121_q(), info.world, (Teleporter)new SignTeleporter(info.world));
                }
                if (player.field_71093_bK != info.destination.pos.dim) {
                    player.field_71133_b.func_184103_al().transferPlayerToDimension(player, info.destination.pos.dim, (Teleporter)new SignTeleporter(info.world));
                }
                player.func_70634_a((double)info.destination.pos.x + 0.5, (double)(info.destination.pos.y + 1), (double)info.destination.pos.z + 0.5);
            }
        }, 1);
    }

    public static void teleportMe(BaseInfo destination, final EntityPlayerMP player, int stackSize) {
        if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            return;
        }
        if (PostHandler.canTeleport(player, destination)) {
            WorldServer world = (WorldServer)destination.pos.getWorld();
            if (world == null) {
                NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.errorWorld", "<world>", destination.pos.world), player);
            } else {
                SPEventHandler.scheduleTask(PostHandler.awaiting.put((UUID)player.func_110124_au(), (TeleportInformation)new TeleportInformation((BaseInfo)destination, (int)stackSize, (WorldServer)world, (BoolRun)new BoolRun(){
                    private short ticksLeft = (short)2400;

                    @Override
                    public boolean run() {
                        short s = this.ticksLeft;
                        this.ticksLeft = (short)(s - 1);
                        if (s <= 0) {
                            awaiting.remove(player.func_110124_au());
                            return true;
                        }
                        return false;
                    }
                })).boolRun);
                NetworkHandler.netWrap.sendTo((IMessage)new TeleportRequestMessage(stackSize, destination.getName()), player);
            }
        }
    }

    public static StonedHashSet getByWorld(String world) {
        StonedHashSet ret = new StonedHashSet();
        for (BaseInfo now : PostHandler.getAllWaystones()) {
            if (!now.pos.sameWorld(world)) continue;
            ret.add(now);
        }
        return ret;
    }

    public static boolean updateWS(BaseInfo newWS, boolean destroyed) {
        if (destroyed) {
            if (allWaystones.remove(PostHandler.getWSbyName(newWS.getName()))) {
                for (Map.Entry<UUID, Pair<MyBlockPosSet, Pair<Integer, Integer>>> entry : playerKnownWaystonePositions.entrySet()) {
                }
                return true;
            }
            return false;
        }
        for (BaseInfo now : allWaystones) {
            if (!now.update(newWS)) continue;
            return true;
        }
        return allWaystones.add(newWS);
    }

    public static boolean addAllDiscoveredByName(UUID player, StringSet ws) {
        MyBlockPosSet set = new MyBlockPosSet();
        StringSet newStrs = new StringSet();
        newStrs.addAll(ws);
        for (String now : ws) {
            for (BaseInfo base : PostHandler.getAllWaystones()) {
                if (!base.getName().equals(now)) continue;
                set.add(base.blockPos);
                newStrs.remove(now);
            }
        }
        ws = newStrs;
        boolean ret = false;
        if (!ws.isEmpty()) {
            if (playerKnownWaystones.containsKey(player)) {
                ret = playerKnownWaystones.get(player).addAll(ws);
            } else {
                StringSet strSet = new StringSet();
                ret = strSet.addAll(ws);
                playerKnownWaystones.put(player, strSet);
            }
        }
        if (playerKnownWaystonePositions.containsKey(player)) {
            return ret | ((MyBlockPosSet)PostHandler.playerKnownWaystonePositions.get((Object)player).a).addAll(set);
        }
        MyBlockPosSet newSet = new MyBlockPosSet();
        ret |= newSet.addAll(set);
        Pair pair = new Pair();
        pair.a = newSet;
        pair.b = new Pair();
        ((Pair)pair.b).a = ClientConfigStorage.INSTANCE.getMaxWaystones();
        ((Pair)pair.b).b = ClientConfigStorage.INSTANCE.getMaxSignposts();
        playerKnownWaystonePositions.put(player, pair);
        return ret;
    }

    public static boolean addAllDiscoveredByPos(UUID player, MyBlockPosSet ws) {
        if (playerKnownWaystonePositions.containsKey(player)) {
            return ((MyBlockPosSet)PostHandler.playerKnownWaystonePositions.get((Object)player).a).addAll(ws);
        }
        MyBlockPosSet newSet = new MyBlockPosSet();
        boolean ret = newSet.addAll(ws);
        Pair pair = new Pair();
        pair.a = newSet;
        pair.b = new Pair();
        ((Pair)pair.b).a = ClientConfigStorage.INSTANCE.getMaxWaystones();
        ((Pair)pair.b).b = ClientConfigStorage.INSTANCE.getMaxSignposts();
        playerKnownWaystonePositions.put(player, pair);
        return ret;
    }

    public static boolean addDiscovered(UUID player, BaseInfo ws) {
        if (ws == null) {
            return false;
        }
        if (playerKnownWaystonePositions.containsKey(player)) {
            boolean ret = ((MyBlockPosSet)PostHandler.playerKnownWaystonePositions.get((Object)player).a).add(ws.blockPos);
            return ret |= !playerKnownWaystonePositions.containsKey(player) || !playerKnownWaystones.get(player).remove(ws.getName());
        }
        MyBlockPosSet newSet = new MyBlockPosSet();
        newSet.add(ws.blockPos);
        Pair pair = new Pair();
        pair.a = newSet;
        pair.b = new Pair();
        ((Pair)pair.b).a = ClientConfigStorage.INSTANCE.getMaxWaystones();
        ((Pair)pair.b).b = ClientConfigStorage.INSTANCE.getMaxSignposts();
        playerKnownWaystonePositions.put(player, pair);
        return !playerKnownWaystonePositions.containsKey(player) || !playerKnownWaystones.get(player).remove(ws.getName());
    }

    public static void refreshDiscovered() {
        HashSet<UUID> toDelete = new HashSet<UUID>();
        HashMap<UUID, MyBlockPosSet> toAdd = new HashMap<UUID, MyBlockPosSet>();
        for (Map.Entry<UUID, StringSet> entry : playerKnownWaystones.entrySet()) {
            StringSet newSet = new StringSet();
            MyBlockPosSet newPosSet = new MyBlockPosSet();
            for (String str : entry.getValue()) {
                for (BaseInfo base : allWaystones) {
                    if (!base.hasName() || !base.getName().equals(str)) continue;
                    newPosSet.add(base.blockPos);
                    newSet.add(str);
                }
            }
            toAdd.put(entry.getKey(), newPosSet);
            entry.getValue().removeAll(newSet);
            if (!entry.getValue().isEmpty()) continue;
            toDelete.add(entry.getKey());
        }
        for (UUID uUID : toDelete) {
            playerKnownWaystones.remove(uUID);
        }
        for (Map.Entry<UUID, StringSet> entry : toAdd.entrySet()) {
            PostHandler.addAllDiscoveredByPos(entry.getKey(), (MyBlockPosSet)((Object)entry.getValue()));
        }
    }

    public static boolean canTeleport(EntityPlayerMP player, BaseInfo target) {
        if (PostHandler.doesPlayerKnowWaystone(player, target)) {
            if (new MyBlockPos((Entity)player).checkInterdimensional(target.blockPos)) {
                return true;
            }
            NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.guiWorldDim"), player);
        } else {
            NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.notDiscovered", "<Waystone>", target.getName()), player);
        }
        return false;
    }

    public static WorldServer getWorldByName(String world, int dim) {
        WorldServer ret = null;
        for (WorldServer now : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (!now.func_72912_H().func_76065_j().equals(world)) continue;
            ret = now;
        }
        if (dim != 0 || world == null) {
            ret = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
        }
        return ret;
    }

    public static boolean addRep(BaseInfo ws) {
        BaseInfo toDelete = allWaystones.getByPos(ws.blockPos);
        allWaystones.removeByPos(toDelete.blockPos);
        allWaystones.add(ws);
        return true;
    }

    public static EntityPlayer getPlayerByName(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
    }

    public static boolean isHandEmpty(EntityPlayer player) {
        return player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150350_a));
    }

    public static StonedHashSet getAllWaystones() {
        StonedHashSet ret = SignpostAdapter.INSTANCE.getExternalBaseInfos();
        ret.addAll(allWaystones);
        return ret;
    }

    public static StonedHashSet getNativeWaystones() {
        return allWaystones;
    }

    public static void setNativeWaystones(StonedHashSet set) {
        allWaystones = set;
    }

    public static StonedHashSet getPlayerKnownWaystones(EntityPlayerMP player) {
        StonedHashSet ret = SignpostAdapter.INSTANCE.getExternalPlayerBaseInfos((EntityPlayer)player);
        for (BaseInfo now : allWaystones) {
            if (!PostHandler.doesPlayerKnowNativeWaystone(player, now)) continue;
            ret.add(now);
        }
        return ret;
    }

    public static boolean addWaystone(BaseInfo baseInfo) {
        return allWaystones.add(baseInfo);
    }

    private static class SignTeleporter
    extends Teleporter {
        public SignTeleporter(WorldServer worldIn) {
            super(worldIn);
        }

        public void func_180266_a(Entity entityIn, float rotationYaw) {
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            return true;
        }

        public boolean func_85188_a(Entity entityIn) {
            return true;
        }

        public void func_85189_a(long worldTime) {
        }
    }

    public static class TeleportInformation {
        public BaseInfo destination;
        public int stackSize;
        public WorldServer world;
        public BoolRun boolRun;

        public TeleportInformation(BaseInfo destination, int stackSize, WorldServer world, BoolRun boolRun) {
            this.destination = destination;
            this.stackSize = stackSize;
            this.world = world;
            this.boolRun = boolRun;
        }
    }
}

