/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks.tiles;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.BigPostPost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.SendAllBigPostBasesMessage;
import gollorum.signpost.network.messages.SendBigPostBasesMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BigBaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Paintable;
import gollorum.signpost.util.Sign;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BigPostPostTile
extends SuperPostPostTile {
    public BigPostPost.BigPostType type = null;
    public static final int DESCRIPTIONLENGTH = 4;
    @Deprecated
    public BigBaseInfo bases = null;

    public BigPostPostTile() {
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (BigPostPostTile.this.func_145838_q() == null) {
                    return false;
                }
                if (BigPostPostTile.this.func_145838_q() instanceof BigPostPost) {
                    BigPostPostTile.this.type = ((BigPostPost)BigPostPostTile.this.func_145838_q()).type;
                }
                return true;
            }
        });
    }

    public BigPostPostTile(BigPostPost.BigPostType type) {
        this.type = type;
    }

    public BigBaseInfo getBases() {
        BaseInfo newBase;
        BigBaseInfo bases = PostHandler.getBigPosts().get(this.toPos());
        if (bases == null) {
            bases = this.type == null ? new BigBaseInfo(BigPostPost.BigPostType.OAK.texture, BigPostPost.BigPostType.OAK.resLocMain) : new BigBaseInfo(this.type.texture, this.type.resLocMain);
            PostHandler.getBigPosts().put(this.toPos(), bases);
        } else if (bases.sign != null && bases.sign.base != null && bases.sign.base.pos == null && (newBase = PostHandler.getWSbyName(bases.sign.base.getName())) != null) {
            bases.sign.base = newBase;
        }
        this.bases = bases;
        return bases;
    }

    @Override
    public void onBlockDestroy(MyBlockPos pos) {
        super.onBlockDestroy(pos);
        this.isCanceled = true;
        BigBaseInfo bases = this.getBases();
        if (bases.sign.overlay != null) {
            EntityItem item = new EntityItem(this.func_145831_w(), (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(bases.sign.overlay.item, 1));
            this.func_145831_w().func_72838_d((Entity)item);
        }
        if (PostHandler.getBigPosts().remove(pos) != null) {
            NetworkHandler.netWrap.sendToAll((IMessage)new SendAllBigPostBasesMessage());
        }
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
        BigBaseInfo bases = this.getBases();
        tagCompound.func_74778_a("base", "" + bases.sign.base);
        tagCompound.func_74768_a("rot", bases.sign.rotation);
        tagCompound.func_74757_a("flip", bases.sign.flip);
        tagCompound.func_74778_a("overlay", "" + (Object)((Object)bases.sign.overlay));
        tagCompound.func_74757_a("point", bases.sign.point);
        tagCompound.func_74778_a("paint", BigPostPostTile.locToString(bases.sign.paint));
        tagCompound.func_74778_a("postPaint", BigPostPostTile.locToString(bases.postPaint));
        for (int i = 0; i < bases.description.length; ++i) {
            tagCompound.func_74778_a("description" + i, bases.description[i]);
        }
        if (bases.equals(this.getPaintObject())) {
            tagCompound.func_74774_a("paintObjectIndex", (byte)1);
        } else if (bases.sign.equals(this.getPaintObject())) {
            tagCompound.func_74774_a("paintObjectIndex", (byte)2);
        } else {
            tagCompound.func_74774_a("paintObjectIndex", (byte)0);
        }
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
        final String base = tagCompound.func_74779_i("base");
        final int rotation = tagCompound.func_74762_e("rot");
        final boolean flip = tagCompound.func_74767_n("flip");
        final Sign.OverlayType overlay = Sign.OverlayType.get(tagCompound.func_74779_i("overlay"));
        final boolean point = tagCompound.func_74767_n("point");
        final String[] description = new String[4];
        final String paint = tagCompound.func_74779_i("paint");
        final String postPaint = tagCompound.func_74779_i("postPaint");
        final BigPostPostTile self = this;
        for (int i = 0; i < 4; ++i) {
            description[i] = tagCompound.func_74779_i("description" + i);
        }
        final byte paintObjectIndex = tagCompound.func_74771_c("paintObjectIndex");
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (BigPostPostTile.this.func_145831_w() == null || BigPostPostTile.this.type == null) {
                    return false;
                }
                if (BigPostPostTile.this.func_145831_w().field_72995_K) {
                    return true;
                }
                BigBaseInfo bases = BigPostPostTile.this.getBases();
                bases.sign.base = PostHandler.getForceWSbyName(base);
                bases.sign.rotation = rotation;
                bases.sign.flip = flip;
                bases.sign.overlay = overlay;
                bases.sign.point = point;
                bases.description = description;
                bases.sign.paint = SuperPostPostTile.stringToLoc(paint);
                bases.postPaint = postPaint == null || postPaint.equals("") || postPaint.equals("null") || postPaint.equals("minecraft:") ? BigPostPostTile.this.type.resLocMain : SuperPostPostTile.stringToLoc(postPaint);
                switch (paintObjectIndex) {
                    case 1: {
                        bases.paintObject = bases;
                        bases.awaitingPaint = true;
                        break;
                    }
                    case 2: {
                        bases.paintObject = bases.sign;
                        bases.awaitingPaint = true;
                        break;
                    }
                    default: {
                        bases.paintObject = null;
                        bases.awaitingPaint = false;
                    }
                }
                NetworkHandler.netWrap.sendToAll((IMessage)new SendBigPostBasesMessage(self, bases));
                return true;
            }
        });
    }

    @Override
    public Sign getSign(EntityPlayer player) {
        BigBaseInfo bases = this.getBases();
        BigPostPost.BigHit hit = (BigPostPost.BigHit)((BigPostPost)this.func_145838_q()).getHitTarget(this.func_145831_w(), this.func_174877_v().func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player);
        if (hit.target.equals((Object)BigPostPost.BigHitTarget.BASE)) {
            return bases.sign;
        }
        return null;
    }

    @Override
    public Paintable getPaintable(EntityPlayer player) {
        BigBaseInfo bases = this.getBases();
        BigPostPost.BigHit hit = (BigPostPost.BigHit)((BigPostPost)this.func_145838_q()).getHitTarget(this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player);
        if (hit.target.equals((Object)BigPostPost.BigHitTarget.BASE)) {
            return bases.sign;
        }
        return bases;
    }

    @Override
    public ResourceLocation getPostPaint() {
        return this.getBases().postPaint;
    }

    @Override
    public void setPostPaint(ResourceLocation loc) {
        this.getBases().postPaint = loc;
    }

    @Override
    public boolean isAwaitingPaint() {
        return this.getBases().awaitingPaint;
    }

    @Override
    public Paintable getPaintObject() {
        return this.getBases().paintObject;
    }

    @Override
    public void setAwaitingPaint(boolean awaitingPaint) {
        this.getBases().awaitingPaint = awaitingPaint;
    }

    @Override
    public void setPaintObject(Paintable paintObject) {
        this.getBases().paintObject = paintObject;
    }

    public String toString() {
        return this.getBases() + " at " + this.toPos();
    }
}

