/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.MyBlockPos;
import java.util.UUID;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BasePost
extends BlockContainer {
    public BasePost() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149663_c("SignpostBase");
        this.setRegistryName("signpost:blockbase");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            BaseInfo ws = BasePost.getWaystoneRootTile(worldIn, pos).getBaseInfo();
            if (ws == null) {
                ws = new BaseInfo(BasePost.generateName(), new MyBlockPos(worldIn, pos, playerIn.field_71093_bK), playerIn.func_110124_au());
                PostHandler.addWaystone(ws);
            }
            if (!playerIn.func_70093_af()) {
                if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)playerIn, ws)) {
                    if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() || ClientConfigStorage.INSTANCE.isDisableDiscovery()) {
                        NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)playerIn);
                    }
                    PostHandler.addDiscovered(playerIn.func_110124_au(), ws);
                }
            } else if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse((EntityPlayerMP)playerIn, "" + ws.owner)) {
                NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (EntityPlayerMP)playerIn);
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BasePostTile().setup();
    }

    public static BasePostTile getWaystoneRootTile(World world, BlockPos pos) {
        TileEntity ret = world.func_175625_s(pos);
        if (ret instanceof BasePostTile) {
            return (BasePostTile)ret;
        }
        return null;
    }

    public static String generateName() {
        String ret;
        int i = 1;
        do {
            ret = "Waystone " + i++;
        } while (PostHandler.getAllWaystones().nameTaken(ret));
        return ret;
    }

    public static void placeServer(World world, MyBlockPos pos, EntityPlayerMP player) {
        BasePostTile tile = BasePost.getWaystoneRootTile(world, pos.toBlockPos());
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = tile.getBaseInfo();
        if (ws == null) {
            if (owner == null) {
                System.out.println("bp ps t null");
            }
            ws = new BaseInfo(name, pos, owner);
            PostHandler.addWaystone(ws);
        } else {
            if (owner == null) {
                System.out.println("bp ps f null");
            }
            ws.setAll(new BaseInfo(name, pos, owner));
        }
        PostHandler.addDiscovered(player.func_110124_au(), ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, world, pos.x, pos.y, pos.z, name));
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, pos.x, pos.y, pos.z), player);
    }

    public static void placeClient(World world, MyBlockPos pos, EntityPlayer player) {
        BaseInfo ws;
        BasePostTile tile = BasePost.getWaystoneRootTile(world, pos.toBlockPos());
        if (tile != null && tile.getBaseInfo() == null && (ws = PostHandler.getAllWaystones().getByPos(pos)) == null) {
            UUID owner = player.func_110124_au();
            if (owner == null) {
                System.out.println("bp pc null");
            }
            PostHandler.getAllWaystones().add(new BaseInfo("", pos, owner));
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new BasePostTile();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }
}

