/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.BlockHandler;
import gollorum.signpost.ItemHandler;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.blocks.tiles.BigPostPostTile;
import gollorum.signpost.blocks.tiles.PostPostTile;
import gollorum.signpost.management.PlayerStorage;
import gollorum.signpost.management.PlayerStore;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    protected BlockHandler blockHandler = BlockHandler.INSTANCE;
    protected ItemHandler itemHandler = ItemHandler.INSTANCE;

    void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this.blockHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.itemHandler);
    }

    void init() {
        CommonProxy commonProxy = this;
        commonProxy.blockHandler.init();
        this.blockHandler.register();
        CommonProxy commonProxy2 = this;
        commonProxy2.itemHandler.init();
        CommonProxy commonProxy3 = this;
        commonProxy3.itemHandler.register();
        this.registerCapabilities();
        this.registerTiles();
        NetworkHandler.register();
        SPEventHandler handler = SPEventHandler.INSTANCE;
        MinecraftForge.EVENT_BUS.register((Object)handler);
    }

    protected void registerTiles() {
        GameRegistry.registerTileEntity(BasePostTile.class, (String)"SignpostBaseTile");
        GameRegistry.registerTileEntity(PostPostTile.class, (String)"SignpostPostTile");
        GameRegistry.registerTileEntity(BigPostPostTile.class, (String)"SignpostBigPostTile");
    }

    protected void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PlayerStore.class, (Capability.IStorage)new PlayerStorage(), PlayerStore.class);
    }

    public World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }

    public World getWorld(String worldName, int dim) {
        return PostHandler.getWorldByName(worldName, dim);
    }

    public World[] getWorlds() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
    }

    public Collection<EntityPlayer> getAllPlayers() {
        LinkedList<EntityPlayer> ret = new LinkedList<EntityPlayer>();
        for (Object now : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!(now instanceof EntityPlayer)) continue;
            ret.add((EntityPlayer)now);
        }
        return ret;
    }
}

