/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.model.animation;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.animation.Clips;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public final class AnimationStateMachine
implements IAnimationStateMachine {
    private final ImmutableMap<String, ITimeValue> parameters;
    private final ImmutableMap<String, IClip> clips;
    private final ImmutableList<String> states;
    private final ImmutableMultimap<String, String> transitions;
    @SerializedName(value="start_state")
    private final String startState;
    private transient boolean shouldHandleSpecialEvents;
    private transient String currentStateName;
    private transient IClip currentState;
    private transient float lastPollTime;
    private static final LoadingCache<Triple<? extends IClip, Float, Float>, Pair<IModelState, Iterable<Event>>> clipCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(100L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Triple<? extends IClip, Float, Float>, Pair<IModelState, Iterable<Event>>>(){

        public Pair<IModelState, Iterable<Event>> load(Triple<? extends IClip, Float, Float> key) throws Exception {
            return Clips.apply((IClip)key.getLeft(), ((Float)key.getMiddle()).floatValue(), ((Float)key.getRight()).floatValue());
        }
    });
    private static final AnimationStateMachine missing = new AnimationStateMachine((ImmutableMap<String, ITimeValue>)ImmutableMap.of(), (ImmutableMap<String, IClip>)ImmutableMap.of((Object)"missingno", (Object)Clips.IdentityClip.INSTANCE), (ImmutableList<String>)ImmutableList.of((Object)"missingno"), (ImmutableMultimap<String, String>)ImmutableMultimap.of(), "missingno");
    private static final Gson asmGson;

    @Deprecated
    public AnimationStateMachine(ImmutableMap<String, ITimeValue> parameters, ImmutableMap<String, IClip> clips, ImmutableList<String> states, ImmutableMap<String, String> transitions, String startState) {
        this(parameters, clips, states, (ImmutableMultimap<String, String>)ImmutableMultimap.copyOf((Multimap)Multimaps.newSetMultimap((Map)Maps.transformValues(transitions, ImmutableSet::of), Sets::newHashSet)), startState);
    }

    public AnimationStateMachine(ImmutableMap<String, ITimeValue> parameters, ImmutableMap<String, IClip> clips, ImmutableList<String> states, ImmutableMultimap<String, String> transitions, String startState) {
        this.parameters = parameters;
        this.clips = clips;
        this.states = states;
        this.transitions = transitions;
        this.startState = startState;
    }

    void initialize() {
        if (this.parameters == null) {
            throw new JsonParseException("Animation State Machine should contain \"parameters\" key.");
        }
        if (this.clips == null) {
            throw new JsonParseException("Animation State Machine should contain \"clips\" key.");
        }
        if (this.states == null) {
            throw new JsonParseException("Animation State Machine should contain \"states\" key.");
        }
        if (this.transitions == null) {
            throw new JsonParseException("Animation State Machine should contain \"transitions\" key.");
        }
        this.shouldHandleSpecialEvents = true;
        this.lastPollTime = Float.NEGATIVE_INFINITY;
        IClip state = (IClip)this.clips.get((Object)this.startState);
        if (!this.clips.containsKey((Object)this.startState) || !this.states.contains((Object)this.startState)) {
            throw new IllegalStateException("unknown state: " + this.startState);
        }
        this.currentStateName = this.startState;
        this.currentState = state;
    }

    @Override
    public Pair<IModelState, Iterable<Event>> apply(float time) {
        if (this.lastPollTime == Float.NEGATIVE_INFINITY) {
            this.lastPollTime = time;
        }
        Pair pair = (Pair)clipCache.getUnchecked((Object)Triple.of((Object)this.currentState, (Object)Float.valueOf(this.lastPollTime), (Object)Float.valueOf(time)));
        this.lastPollTime = time;
        boolean shouldFilter = false;
        if (this.shouldHandleSpecialEvents) {
            for (Event event : ImmutableList.copyOf((Iterable)((Iterable)pair.getRight())).reverse()) {
                if (!event.event().startsWith("!")) continue;
                shouldFilter = true;
                if (event.event().startsWith("!transition:")) {
                    String newState = event.event().substring("!transition:".length());
                    this.transition(newState);
                    continue;
                }
                FMLLog.log.error("Unknown special event \"{}\", ignoring.", (Object)event.event());
            }
        }
        if (!shouldFilter) {
            return pair;
        }
        return Pair.of((Object)pair.getLeft(), (Object)Iterables.filter((Iterable)((Iterable)pair.getRight()), (Predicate)new Predicate<Event>(){

            public boolean apply(Event event) {
                return !event.event().startsWith("!");
            }
        }));
    }

    @Override
    public void transition(String newState) {
        IClip nc = (IClip)this.clips.get((Object)newState);
        if (!this.clips.containsKey((Object)newState) || !this.states.contains((Object)newState)) {
            throw new IllegalStateException("unknown state: " + newState);
        }
        if (!this.transitions.containsEntry((Object)this.currentStateName, (Object)newState)) {
            throw new IllegalArgumentException("no transition from current clip \"" + this.currentStateName + "\" to the clip \"" + newState + "\" found.");
        }
        this.currentStateName = newState;
        this.currentState = nc;
    }

    @Override
    public String currentState() {
        return this.currentStateName;
    }

    @Override
    public void shouldHandleSpecialEvents(boolean value) {
        this.shouldHandleSpecialEvents = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SideOnly(value=Side.CLIENT)
    public static IAnimationStateMachine load(cep manager, nf location, ImmutableMap<String, ITimeValue> customParameters) {
        try {
            AnimationStateMachine animationStateMachine;
            Object object;
            ceo resource;
            block17: {
                block18: {
                    resource = manager.a(location);
                    object = null;
                    ClipResolver clipResolver = new ClipResolver();
                    ParameterResolver parameterResolver = new ParameterResolver(customParameters);
                    Clips.CommonClipTypeAdapterFactory.INSTANCE.setClipResolver(clipResolver);
                    TimeValues.CommonTimeValueTypeAdapterFactory.INSTANCE.setValueResolver(parameterResolver);
                    AnimationStateMachine asm = (AnimationStateMachine)asmGson.fromJson((Reader)new InputStreamReader(resource.b(), StandardCharsets.UTF_8), AnimationStateMachine.class);
                    clipResolver.asm = asm;
                    parameterResolver.asm = asm;
                    asm.initialize();
                    animationStateMachine = asm;
                    if (resource == null) break block17;
                    if (object == null) break block18;
                    try {
                        resource.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block17;
                }
                resource.close();
            }
            return animationStateMachine;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (resource != null) {
                            if (object != null) {
                                try {
                                    resource.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                resource.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (JsonParseException | IOException e) {
                    FMLLog.log.error("Exception loading Animation State Machine {}, skipping", (Object)location, (Object)e);
                    object = missing;
                    return object;
                }
            }
        }
        finally {
            Clips.CommonClipTypeAdapterFactory.INSTANCE.setClipResolver(null);
            TimeValues.CommonTimeValueTypeAdapterFactory.INSTANCE.setValueResolver(null);
        }
    }

    public static AnimationStateMachine getMissing() {
        return missing;
    }

    static {
        missing.initialize();
        asmGson = new GsonBuilder().registerTypeAdapter(ImmutableList.class, (Object)JsonUtils.ImmutableListTypeAdapter.INSTANCE).registerTypeAdapter(ImmutableMap.class, (Object)JsonUtils.ImmutableMapTypeAdapter.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)Clips.CommonClipTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)TimeValues.CommonTimeValueTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)TransitionsAdapterFactory.INSTANCE).setPrettyPrinting().enableComplexMapKeySerialization().disableHtmlEscaping().create();
    }

    private static enum TransitionsAdapterFactory implements TypeAdapterFactory
    {
        INSTANCE;


        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != ImmutableMultimap.class || !(type.getType() instanceof ParameterizedType)) {
                return null;
            }
            Type[] typeArguments = ((ParameterizedType)type.getType()).getActualTypeArguments();
            if (typeArguments.length != 2 || typeArguments[0] != String.class || typeArguments[1] != String.class) {
                return null;
            }
            final TypeAdapter mapAdapter = gson.getAdapter((TypeToken)new TypeToken<Map<String, Collection<String>>>(){});
            final TypeAdapter collectionAdapter = gson.getAdapter((TypeToken)new TypeToken<Collection<String>>(){});
            return new TypeAdapter<ImmutableMultimap<String, String>>(){

                public void write(JsonWriter out, ImmutableMultimap<String, String> value) throws IOException {
                    mapAdapter.write(out, (Object)value.asMap());
                }

                public ImmutableMultimap<String, String> read(JsonReader in) throws IOException {
                    ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                    in.beginObject();
                    block4: while (in.hasNext()) {
                        String key = in.nextName();
                        switch (in.peek()) {
                            case STRING: {
                                builder.put((Object)key, (Object)in.nextString());
                                continue block4;
                            }
                            case BEGIN_ARRAY: {
                                builder.putAll((Object)key, (Iterable)collectionAdapter.read(in));
                                continue block4;
                            }
                        }
                        throw new JsonParseException("Expected String or Array, got " + in.peek());
                    }
                    in.endObject();
                    return builder.build();
                }
            };
        }
    }

    private static final class ParameterResolver
    implements Function<String, ITimeValue> {
        private final ImmutableMap<String, ITimeValue> customParameters;
        private AnimationStateMachine asm;

        public ParameterResolver(ImmutableMap<String, ITimeValue> customParameters) {
            this.customParameters = customParameters;
        }

        @Override
        public ITimeValue apply(String name) {
            if (this.asm.parameters.containsKey((Object)name)) {
                return (ITimeValue)this.asm.parameters.get((Object)name);
            }
            return (ITimeValue)this.customParameters.get((Object)name);
        }
    }

    private static final class ClipResolver
    implements Function<String, IClip> {
        private AnimationStateMachine asm;

        private ClipResolver() {
        }

        @Override
        public IClip apply(String name) {
            return (IClip)this.asm.clips.get((Object)name);
        }
    }
}

