/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import javax.annotation.Nonnull;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AbstractBrewingRecipe<T>
implements IBrewingRecipe {
    @Nonnull
    private final aip input;
    private final T ingredient;
    private final aip output;

    protected AbstractBrewingRecipe(@Nonnull aip input, @Nonnull T ingredient, @Nonnull aip output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
    }

    @Override
    public boolean isInput(@Nonnull aip stack) {
        return OreDictionary.itemMatches(this.getInput(), stack, false);
    }

    @Override
    @Nonnull
    public aip getOutput(@Nonnull aip input, @Nonnull aip ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.getOutput().l() : aip.a;
    }

    @Nonnull
    public aip getInput() {
        return this.input;
    }

    @Nonnull
    public T getIngredient() {
        return this.ingredient;
    }

    @Nonnull
    public aip getOutput() {
        return this.output;
    }
}

