/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.model.animation.IJointClip;
import net.minecraftforge.common.model.animation.JointClips;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.fml.common.FMLLog;

public class ModelBlockAnimation {
    private final ImmutableMap<String, ImmutableMap<String, float[]>> joints;
    private final ImmutableMap<String, MBClip> clips;
    private transient ImmutableMultimap<Integer, MBJointWeight> jointIndexMap;
    private static final Gson mbaGson = new GsonBuilder().registerTypeAdapter(ImmutableList.class, (Object)JsonUtils.ImmutableListTypeAdapter.INSTANCE).registerTypeAdapter(ImmutableMap.class, (Object)JsonUtils.ImmutableMapTypeAdapter.INSTANCE).setPrettyPrinting().enableComplexMapKeySerialization().disableHtmlEscaping().create();
    private static final ModelBlockAnimation defaultModelBlockAnimation = new ModelBlockAnimation((ImmutableMap<String, ImmutableMap<String, float[]>>)ImmutableMap.of(), (ImmutableMap<String, MBClip>)ImmutableMap.of());

    public ModelBlockAnimation(ImmutableMap<String, ImmutableMap<String, float[]>> joints, ImmutableMap<String, MBClip> clips) {
        this.joints = joints;
        this.clips = clips;
    }

    public ImmutableMap<String, ? extends IClip> getClips() {
        return this.clips;
    }

    public ImmutableCollection<MBJointWeight> getJoint(int i2) {
        if (this.jointIndexMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry info : this.joints.entrySet()) {
                ImmutableMap.Builder weightBuilder = ImmutableMap.builder();
                for (Map.Entry e : ((ImmutableMap)info.getValue()).entrySet()) {
                    weightBuilder.put((Object)Integer.parseInt((String)e.getKey()), e.getValue());
                }
                ImmutableMap weightMap = weightBuilder.build();
                for (Map.Entry e : weightMap.entrySet()) {
                    builder.put(e.getKey(), (Object)new MBJointWeight((String)info.getKey(), (ImmutableMap<Integer, float[]>)weightMap));
                }
            }
            this.jointIndexMap = builder.build();
        }
        return this.jointIndexMap.get((Object)i2);
    }

    @Nullable
    public TRSRTransformation getPartTransform(IModelState state, bvq part, int i2) {
        ImmutableCollection<MBJointWeight> infos = this.getJoint(i2);
        if (!infos.isEmpty()) {
            Matrix4f m = new Matrix4f();
            float weight = 0.0f;
            for (MBJointWeight info : infos) {
                MBJoint joint;
                Optional<TRSRTransformation> trOp;
                if (!info.getWeights().containsKey((Object)i2) || !(trOp = state.apply(Optional.of(joint = new MBJoint(info.getName())))).isPresent() || trOp.get().isIdentity()) continue;
                float w = ((float[])info.getWeights().get((Object)i2))[0];
                Matrix4f tmp = trOp.get().getMatrix();
                tmp.mul(w);
                m.add(tmp);
                weight += w;
            }
            if ((double)weight > 1.0E-5) {
                m.mul(1.0f / weight);
                return new TRSRTransformation(m);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModelBlockAnimation loadVanillaAnimation(cep manager, nf armatureLocation) {
        try {
            try (ceo resource = manager.a(armatureLocation);){
                ModelBlockAnimation mba;
                ModelBlockAnimation modelBlockAnimation = mba = (ModelBlockAnimation)mbaGson.fromJson((Reader)new InputStreamReader(resource.b(), StandardCharsets.UTF_8), ModelBlockAnimation.class);
                return modelBlockAnimation;
            }
            catch (FileNotFoundException e) {
                return defaultModelBlockAnimation;
            }
        }
        catch (JsonParseException | IOException e) {
            FMLLog.log.error("Exception loading vanilla model animation {}, skipping", (Object)armatureLocation, (Object)e);
            return defaultModelBlockAnimation;
        }
    }

    protected static class Parameter {
        protected Parameter() {
        }

        public static enum Interpolation {
            LINEAR,
            NEAREST;

        }

        public static enum Type {
            UNIFORM;

        }

        public static enum Variable {
            X,
            Y,
            Z,
            XROT,
            YROT,
            ZROT,
            ANGLE,
            SCALE,
            XS,
            YS,
            ZS,
            XORIGIN,
            YORIGIN,
            ZORIGIN;

        }
    }

    protected static class MBJointWeight {
        private final String name;
        private final ImmutableMap<Integer, float[]> weights;

        public MBJointWeight(String name, ImmutableMap<Integer, float[]> weights) {
            this.name = name;
            this.weights = weights;
        }

        public String getName() {
            return this.name;
        }

        public ImmutableMap<Integer, float[]> getWeights() {
            return this.weights;
        }
    }

    protected static class MBJoint
    implements IJoint {
        private final String name;

        public MBJoint(String name) {
            this.name = name;
        }

        @Override
        public TRSRTransformation getInvBindPose() {
            return TRSRTransformation.identity();
        }

        @Override
        public Optional<? extends IJoint> getParent() {
            return Optional.empty();
        }

        public String getName() {
            return this.name;
        }
    }

    protected static class MBClip
    implements IClip {
        private final boolean loop;
        @SerializedName(value="joint_clips")
        private final ImmutableMap<String, ImmutableList<MBVariableClip>> jointClipsFlat;
        private transient ImmutableMap<String, MBJointClip> jointClips;
        @SerializedName(value="events")
        private final ImmutableMap<String, String> eventsRaw;
        private transient TreeMap<Float, Event> events;

        public MBClip(boolean loop, ImmutableMap<String, ImmutableList<MBVariableClip>> clips, ImmutableMap<String, String> events) {
            this.loop = loop;
            this.jointClipsFlat = clips;
            this.eventsRaw = events;
        }

        private void initialize() {
            if (this.jointClips == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry e : this.jointClipsFlat.entrySet()) {
                    builder.put(e.getKey(), (Object)new MBJointClip(this.loop, (ImmutableList<MBVariableClip>)((ImmutableList)e.getValue())));
                }
                this.jointClips = builder.build();
                this.events = Maps.newTreeMap();
                if (!this.eventsRaw.isEmpty()) {
                    TreeMap times = Maps.newTreeMap();
                    for (String time : this.eventsRaw.keySet()) {
                        times.put(Float.valueOf(Float.parseFloat(time)), time);
                    }
                    float lastTime = Float.POSITIVE_INFINITY;
                    if (this.loop) {
                        lastTime = ((Float)times.firstKey()).floatValue();
                    }
                    for (Map.Entry entry : times.descendingMap().entrySet()) {
                        float time = ((Float)entry.getKey()).floatValue();
                        float offset = lastTime - time;
                        if (this.loop) {
                            offset = 1.0f - (1.0f - offset) % 1.0f;
                        }
                        this.events.put(Float.valueOf(time), new Event((String)this.eventsRaw.get(entry.getValue()), offset));
                    }
                }
            }
        }

        @Override
        public IJointClip apply(IJoint joint) {
            MBJoint mbJoint;
            MBJointClip clip;
            this.initialize();
            if (joint instanceof MBJoint && (clip = (MBJointClip)this.jointClips.get((Object)(mbJoint = (MBJoint)joint).getName())) != null) {
                return clip;
            }
            return JointClips.IdentityJointClip.INSTANCE;
        }

        @Override
        public Iterable<Event> pastEvents(final float lastPollTime, final float time) {
            this.initialize();
            return new Iterable<Event>(){

                @Override
                public Iterator<Event> iterator() {
                    return new UnmodifiableIterator<Event>(){
                        private Float curKey;
                        private Event firstEvent;
                        private float stopTime;
                        {
                            if (lastPollTime >= time) {
                                this.curKey = null;
                            } else {
                                float tmp;
                                float fractTime = time - (float)Math.floor(time);
                                float fractLastTime = lastPollTime - (float)Math.floor(lastPollTime);
                                if (fractLastTime > fractTime) {
                                    tmp = fractTime;
                                    fractTime = fractLastTime;
                                    fractLastTime = tmp;
                                }
                                if (fractTime - fractLastTime > 0.5f) {
                                    tmp = fractTime;
                                    fractTime = fractLastTime;
                                    fractLastTime = tmp;
                                }
                                this.stopTime = fractLastTime;
                                this.curKey = events.floorKey(Float.valueOf(fractTime));
                                if (this.curKey == null && loop && !events.isEmpty()) {
                                    this.curKey = (Float)events.lastKey();
                                }
                                if (this.curKey != null) {
                                    float checkCurTime = this.curKey.floatValue();
                                    float checkStopTime = this.stopTime;
                                    if (checkCurTime >= fractTime) {
                                        checkCurTime -= 1.0f;
                                    }
                                    if (checkStopTime >= fractTime) {
                                        checkStopTime -= 1.0f;
                                    }
                                    float offset = fractTime - checkCurTime;
                                    Event event = (Event)events.get(this.curKey);
                                    if (checkCurTime < checkStopTime) {
                                        this.curKey = null;
                                    } else if (offset != event.offset()) {
                                        this.firstEvent = new Event(event.event(), offset);
                                    }
                                }
                            }
                        }

                        public boolean hasNext() {
                            return this.curKey != null;
                        }

                        public Event next() {
                            Event event;
                            if (this.curKey == null) {
                                throw new NoSuchElementException();
                            }
                            if (this.firstEvent == null) {
                                event = (Event)events.get(this.curKey);
                            } else {
                                event = this.firstEvent;
                                this.firstEvent = null;
                            }
                            this.curKey = events.lowerKey(this.curKey);
                            if (this.curKey == null && loop) {
                                this.curKey = (Float)events.lastKey();
                            }
                            if (this.curKey != null) {
                                float checkStopTime;
                                for (checkStopTime = this.stopTime; this.curKey.floatValue() + ((Event)events.get(this.curKey)).offset() < checkStopTime; checkStopTime -= 1.0f) {
                                }
                                while (this.curKey.floatValue() + ((Event)events.get(this.curKey)).offset() >= checkStopTime + 1.0f) {
                                    checkStopTime += 1.0f;
                                }
                                if (this.curKey.floatValue() <= checkStopTime) {
                                    this.curKey = null;
                                }
                            }
                            return event;
                        }
                    };
                }
            };
        }

        protected static class MBJointClip
        implements IJointClip {
            private final boolean loop;
            private final ImmutableList<MBVariableClip> variables;

            public MBJointClip(boolean loop, ImmutableList<MBVariableClip> variables) {
                this.loop = loop;
                this.variables = variables;
                EnumSet hadVar = Sets.newEnumSet(Collections.emptyList(), Parameter.Variable.class);
                for (MBVariableClip var : variables) {
                    if (hadVar.contains((Object)var.variable)) {
                        throw new IllegalArgumentException("duplicate variable: " + var);
                    }
                    hadVar.add(var.variable);
                }
            }

            @Override
            public TRSRTransformation apply(float time) {
                time = (float)((double)time - Math.floor(time));
                Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
                Vector3f origin = new Vector3f(0.0f, 0.0f, 0.0f);
                AxisAngle4f rotation = new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f);
                for (MBVariableClip var : this.variables) {
                    int length = this.loop ? var.samples.length : var.samples.length - 1;
                    float timeScaled = time * (float)length;
                    int s1 = rk.a((int)((int)Math.round(Math.floor(timeScaled))), (int)0, (int)(length - 1));
                    float progress = timeScaled - (float)s1;
                    int s2 = s1 + 1;
                    if (s2 == length && this.loop) {
                        s2 = 0;
                    }
                    float value = 0.0f;
                    switch (var.interpolation) {
                        case LINEAR: {
                            if (var.variable == Parameter.Variable.ANGLE) {
                                float v1 = var.samples[s1];
                                float v2 = var.samples[s2];
                                float diff = ((v2 - v1) % 360.0f + 540.0f) % 360.0f - 180.0f;
                                value = v1 + diff * progress;
                                break;
                            }
                            value = var.samples[s1] * (1.0f - progress) + var.samples[s2] * progress;
                            break;
                        }
                        case NEAREST: {
                            value = var.samples[progress < 0.5f ? s1 : s2];
                        }
                    }
                    switch (var.variable) {
                        case X: {
                            translation.x = value;
                            break;
                        }
                        case Y: {
                            translation.y = value;
                            break;
                        }
                        case Z: {
                            translation.z = value;
                            break;
                        }
                        case XROT: {
                            rotation.x = value;
                            break;
                        }
                        case YROT: {
                            rotation.y = value;
                            break;
                        }
                        case ZROT: {
                            rotation.z = value;
                            break;
                        }
                        case ANGLE: {
                            rotation.angle = (float)Math.toRadians(value);
                            break;
                        }
                        case SCALE: {
                            scale.y = scale.z = value;
                            scale.x = scale.z;
                            break;
                        }
                        case XS: {
                            scale.x = value;
                            break;
                        }
                        case YS: {
                            scale.y = value;
                            break;
                        }
                        case ZS: {
                            scale.z = value;
                            break;
                        }
                        case XORIGIN: {
                            origin.x = value - 0.5f;
                            break;
                        }
                        case YORIGIN: {
                            origin.y = value - 0.5f;
                            break;
                        }
                        case ZORIGIN: {
                            origin.z = value - 0.5f;
                        }
                    }
                }
                Quat4f rot = new Quat4f();
                rot.set(rotation);
                TRSRTransformation base = new TRSRTransformation(translation, rot, scale, null);
                Vector3f negOrigin = new Vector3f(origin);
                negOrigin.negate();
                base = new TRSRTransformation(origin, null, null, null).compose(base).compose(new TRSRTransformation(negOrigin, null, null, null));
                return TRSRTransformation.blockCenterToCorner(base);
            }
        }
    }

    protected static class MBVariableClip {
        private final Parameter.Variable variable;
        private final Parameter.Type type;
        private final Parameter.Interpolation interpolation;
        private final float[] samples;

        public MBVariableClip(Parameter.Variable variable, Parameter.Type type, Parameter.Interpolation interpolation, float[] samples) {
            this.variable = variable;
            this.type = type;
            this.interpolation = interpolation;
            this.samples = samples;
        }
    }
}

