/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketBlockInteraction;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetCollectionBox
extends PacketBlockInteraction {
    private float playerYaw;
    private boolean useBitGrid;
    private EnumFacing facingBox;

    public PacketSetCollectionBox() {
    }

    public PacketSetCollectionBox(float playerYaw, boolean useBitGrid, EnumFacing facingBox, BlockPos pos, EnumFacing facingPlacement, Vec3d hit) {
        super(pos, facingPlacement, hit);
        this.playerYaw = playerYaw;
        this.useBitGrid = useBitGrid;
        this.facingBox = facingBox;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeFloat(this.playerYaw);
        buffer.writeBoolean(this.useBitGrid);
        buffer.writeInt(this.facingBox.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.playerYaw = buffer.readFloat();
        this.useBitGrid = buffer.readBoolean();
        this.facingBox = EnumFacing.func_82600_a((int)buffer.readInt());
    }

    public static class Handler
    implements IMessageHandler<PacketSetCollectionBox, IMessage> {
        public IMessage onMessage(final PacketSetCollectionBox message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (ItemStackHelper.isChiseledArmorStack(stack)) {
                        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
                        ItemChiseledArmor.writeCollectionBoxToNBT(nbt, message.playerYaw, message.useBitGrid, message.facingBox, message.pos, message.side, message.hit);
                        stack.func_77982_d(nbt);
                        player.field_71069_bz.func_75142_b();
                    }
                }
            });
            return null;
        }
    }
}

