/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.helper.BitAreaHelper;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.packet.PacketBlockInteraction;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketReadBlockStates
extends PacketBlockInteraction
implements IMessage {
    private Vec3i drawnStartPoint;
    private BitToolSettingsHelper.ModelReadData modelingData = new BitToolSettingsHelper.ModelReadData();

    public PacketReadBlockStates() {
    }

    public PacketReadBlockStates(BlockPos pos, Vec3d hit, Vec3i drawnStartPoint, BitToolSettingsHelper.ModelReadData modelingData) {
        super(pos, EnumFacing.UP, hit);
        this.drawnStartPoint = drawnStartPoint;
        this.modelingData = modelingData;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        if (BitIOHelper.notNullToBuffer(buffer, this.drawnStartPoint)) {
            buffer.writeInt(this.drawnStartPoint.func_177958_n());
            buffer.writeInt(this.drawnStartPoint.func_177956_o());
            buffer.writeInt(this.drawnStartPoint.func_177952_p());
        }
        this.modelingData.toBytes(buffer);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        if (buffer.readBoolean()) {
            this.drawnStartPoint = new Vec3i(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        this.modelingData.fromBytes(buffer);
    }

    public static class Handler
    implements IMessageHandler<PacketReadBlockStates, IMessage> {
        public IMessage onMessage(final PacketReadBlockStates message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (ItemStackHelper.isModelingToolStack(stack)) {
                        BitAreaHelper.readBlockStates(stack, (EntityPlayer)player, player.field_70170_p, message.pos, message.hit, message.drawnStartPoint, message.modelingData);
                    }
                }
            });
            return null;
        }
    }
}

