/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.item.ItemBitWrench;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackHelper {
    public static NBTTagCompound initNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static int getInt(NBTTagCompound nbt, int intValue, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            intValue = nbt.func_74762_e(key);
        }
        return intValue;
    }

    public static void setInt(EntityPlayer player, ItemStack stack, int intValue, String key) {
        NBTTagCompound nbt = ItemStackHelper.initNBT(stack);
        nbt.func_74768_a(key, intValue);
        player.field_71069_bz.func_75142_b();
    }

    public static boolean getBoolean(NBTTagCompound nbt, boolean booleanValue, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            booleanValue = nbt.func_74767_n(key);
        }
        return booleanValue;
    }

    public static void setBoolean(EntityPlayer player, ItemStack stack, boolean booleanValue, String key) {
        NBTTagCompound nbt = ItemStackHelper.initNBT(stack);
        nbt.func_74757_a(key, booleanValue);
        player.field_71069_bz.func_75142_b();
    }

    public static ItemStack getStack(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null ? ItemStackHelper.loadStackFromNBT(nbt, key) : ItemStack.field_190927_a;
    }

    public static void setStack(EntityPlayer player, ItemStack stack, ItemStack stackToSet, String key) {
        NBTTagCompound nbt = ItemStackHelper.initNBT(stack);
        ItemStackHelper.saveStackToNBT(nbt, stackToSet, key);
        player.field_71069_bz.func_75142_b();
    }

    public static void saveStackToNBT(NBTTagCompound nbt, ItemStack stack, String key) {
        NBTTagCompound nbt2 = new NBTTagCompound();
        stack.func_77955_b(nbt2);
        nbt.func_74782_a(key, (NBTBase)nbt2);
    }

    public static ItemStack loadStackFromNBT(NBTTagCompound nbt, String key) {
        ItemStack stack = ItemStack.field_190927_a;
        if (nbt.func_74764_b(key)) {
            stack = new ItemStack((NBTTagCompound)nbt.func_74781_a(key));
        }
        return stack;
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key);
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        return stack.func_77978_p();
    }

    public static NBTTagCompound getNBTOrNew(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
    }

    public static boolean isModelingToolStack(ItemStack stack) {
        return ItemStackHelper.isModelingToolItem(stack.func_77973_b());
    }

    public static boolean isModelingToolItem(Item item) {
        return item != null && item instanceof ItemModelingTool;
    }

    public static boolean isSculptingToolStack(ItemStack stack) {
        return ItemStackHelper.isSculptingToolItem(stack.func_77973_b());
    }

    public static boolean isSculptingToolItem(Item item) {
        return item != null && item instanceof ItemSculptingTool;
    }

    public static boolean isBitToolStack(ItemStack stack) {
        return ItemStackHelper.isBitToolItem(stack.func_77973_b());
    }

    public static boolean isBitToolItem(Item item) {
        return item != null && item instanceof ItemBitToolBase;
    }

    public static boolean isBitWrenchStack(ItemStack stack) {
        return ItemStackHelper.isBitWrenchItem(stack.func_77973_b());
    }

    public static boolean isBitWrenchItem(Item item) {
        return item != null && item instanceof ItemBitWrench;
    }

    public static boolean isChiseledArmorStack(ItemStack stack) {
        return ItemStackHelper.isChiseledArmorItem(stack.func_77973_b());
    }

    public static boolean isChiseledArmorItem(Item item) {
        return item != null && item instanceof ItemChiseledArmor;
    }

    public static boolean isDesignStack(ItemStack stack) {
        return ItemStackHelper.isDesignItemType(ChiselsAndBitsAPIAccess.apiInstance.getItemType(stack));
    }

    public static boolean isDesignItemType(ItemType itemType) {
        return itemType == ItemType.MIRROR_DESIGN || itemType == ItemType.NEGATIVE_DESIGN || itemType == ItemType.POSITIVE_DESIGN;
    }

    public static NBTTagCompound getArmorData(NBTTagCompound armorNbt) {
        return armorNbt.func_74775_l("data");
    }

    public static ItemStack getChiseledArmorStack(EntityPlayer player, @Nullable ItemChiseledArmor.ArmorType armorType, int indexArmorSet) {
        if (armorType == null) {
            return player.func_184614_ca();
        }
        if (indexArmorSet == 0) {
            return player.func_184582_a(armorType.getEquipmentSlot());
        }
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        return cap == null ? ItemStack.field_190927_a : cap.getStackInSlot(armorType.getSlotIndex(indexArmorSet));
    }

    public static boolean isChiseledArmorNotEmpty(ItemStack stack) {
        return ItemStackHelper.getArmorData(ItemStackHelper.getNBTOrNew(stack)).func_74767_n("notEmpty");
    }
}

