/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GlOperation {
    private final GlOperationType type;
    private float x;
    private float y;
    private float z;
    private float angle;

    public GlOperation(GlOperationType type) {
        this.type = type;
    }

    public GlOperation(GlOperationType type, float x, float y, float z) {
        this(type);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GlOperation(GlOperationType type, float x, float y, float z, float angle) {
        this(type, x, y, z);
        this.angle = angle;
    }

    public GlOperation(NBTTagCompound nbt) {
        this.type = GlOperationType.values()[nbt.func_74762_e("type")];
        this.x = nbt.func_74760_g("x");
        this.y = nbt.func_74760_g("y");
        this.z = nbt.func_74760_g("z");
        this.angle = nbt.func_74760_g("a");
    }

    public static GlOperation createTranslation(float x, float y, float z) {
        return new GlOperation(GlOperationType.TRANSLATION, x, y, z);
    }

    public static GlOperation createRotation(float angle, float x, float y, float z) {
        return new GlOperation(GlOperationType.ROTATION, x, y, z, angle);
    }

    public static GlOperation createScale(float x, float y, float z) {
        return new GlOperation(GlOperationType.SCALE, x, y, z);
    }

    public boolean hasData() {
        return this.x != 0.0f || this.y != 0.0f || this.z != 0.0f || this.type == GlOperationType.ROTATION && this.angle % 360.0f != 0.0f;
    }

    public void execute() {
        switch (this.type) {
            case TRANSLATION: {
                GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)this.z);
                break;
            }
            case ROTATION: {
                GlStateManager.func_179114_b((float)this.angle, (float)this.x, (float)this.y, (float)this.z);
                break;
            }
            case SCALE: {
                GlStateManager.func_179152_a((float)this.x, (float)this.y, (float)this.z);
            }
        }
    }

    public static void executeList(List<GlOperation> glOperations) {
        for (GlOperation glOperation : glOperations) {
            glOperation.execute();
        }
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74776_a("x", this.x);
        nbt.func_74776_a("y", this.y);
        nbt.func_74776_a("z", this.z);
        nbt.func_74776_a("a", this.angle);
    }

    public static void saveListToNBT(NBTTagCompound nbt, String key, List<GlOperation> glOperations) {
        NBTTagList glOperationsNbt = new NBTTagList();
        for (GlOperation glOperation : glOperations) {
            NBTTagCompound glOperationNbt = new NBTTagCompound();
            glOperation.saveToNBT(glOperationNbt);
            glOperationsNbt.func_74742_a((NBTBase)glOperationNbt);
        }
        nbt.func_74782_a(key, (NBTBase)glOperationsNbt);
    }

    public static void loadListFromNBT(NBTTagCompound nbt, String key, List<GlOperation> glOperations) {
        glOperations.clear();
        NBTTagList glOperationsNbt = nbt.func_150295_c(key, 10);
        for (int i = 0; i < glOperationsNbt.func_74745_c(); ++i) {
            glOperations.add(new GlOperation(glOperationsNbt.func_150305_b(i)));
        }
    }

    public GlOperationType getType() {
        return this.type;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public static enum GlOperationType {
        TRANSLATION("Translation"),
        ROTATION("Rotation"),
        SCALE("Scale");

        private String name;

        private GlOperationType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

