/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.sound;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.client.sound.SoundBuilder;
import org.orecruncher.dsurround.client.sound.SoundConfigProcessor;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.dsurround.registry.config.SoundMetadataConfig;
import org.orecruncher.dsurround.registry.sound.SoundMetadata;
import org.orecruncher.lib.compat.PositionedSoundUtil;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class SoundRegistry
extends Registry {
    public static final SoundCategory FOOTSTEPS = SoundCategory.valueOf((String)"DS_FOOTSTEPS");
    public static final SoundCategory BIOME = SoundCategory.valueOf((String)"DS_BIOME");
    public static final float MIN_SOUNDFACTOR = 0.0f;
    public static final float MAX_SOUNDFACTOR = 4.0f;
    public static final float DEFAULT_SOUNDFACTOR = 1.0f;
    private final Set<ResourceLocation> blockedSounds = new ObjectOpenHashSet(32);
    private final Object2IntOpenHashMap<ResourceLocation> soundCull = new Object2IntOpenHashMap(32);
    private final Object2FloatOpenHashMap<ResourceLocation> volumeControl = new Object2FloatOpenHashMap(32);
    private final Map<ResourceLocation, SoundMetadata> soundMetadata = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, SoundEvent> myRegistry = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceLocation, SoundEvent> replacements = new Object2ObjectOpenHashMap();

    public SoundRegistry() {
        super("Sound Registry");
        this.volumeControl.defaultReturnValue(1.0f);
    }

    @Override
    protected void preInit() {
        this.soundCull.clear();
        this.blockedSounds.clear();
        this.volumeControl.clear();
        this.soundMetadata.clear();
        this.myRegistry.clear();
        this.replacements.clear();
        this.bakeSoundRegistry();
        for (String line : ModOptions.sound.soundSettings) {
            String[] parts = line.split(" ");
            if (parts.length < 2) {
                ModBase.log().warn("Missing tokens in sound settings? (%s)", new Object[]{line});
                continue;
            }
            ResourceLocation res = new ResourceLocation(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                if ("cull".compareToIgnoreCase(parts[i]) == 0) {
                    this.soundCull.put((Object)res, -ModOptions.sound.soundCullingThreshold);
                    continue;
                }
                if ("block".compareToIgnoreCase(parts[i]) == 0) {
                    this.blockedSounds.add(res);
                    continue;
                }
                try {
                    int volume = Integer.parseInt(parts[i]);
                    this.volumeControl.put((Object)res, MathStuff.clamp((float)((float)volume / 100.0f), (float)0.0f, (float)4.0f));
                    continue;
                }
                catch (Throwable t) {
                    ModBase.log().warn("Unrecognized token %s (%s)", new Object[]{parts[i], line});
                }
            }
        }
        ResourceLocation bowLooseResource = new ResourceLocation("dsurround", "bow.loose");
        if (!this.isSoundBlocked(bowLooseResource)) {
            SoundEvent bowLoose = this.getSound(bowLooseResource);
            this.replacements.put((Object)new ResourceLocation("minecraft:entity.arrow.shoot"), (Object)bowLoose);
            this.replacements.put((Object)new ResourceLocation("minecraft:entity.skeleton.shoot"), (Object)bowLoose);
        }
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        this.soundMetadata.putAll(cfg.sounds.entrySet().stream().collect(Collectors.toMap(e -> new ResourceLocation((String)e.getKey()), e -> new SoundMetadata((SoundMetadataConfig)e.getValue()))));
    }

    @Override
    protected void complete() {
        ModBase.log().info("[%s] %d sound events in private registry", new Object[]{this.getName(), this.myRegistry.size()});
    }

    private void bakeSoundRegistry() {
        ResourceLocation soundFile = new ResourceLocation("dsurround", "sounds.json");
        try (SoundConfigProcessor proc = new SoundConfigProcessor(soundFile);){
            proc.forEach((sound2, meta) -> {
                SoundMetadata data = new SoundMetadata(meta);
                ResourceLocation resource = new ResourceLocation("dsurround", sound2);
                this.soundMetadata.put(resource, data);
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SoundEngine.instance().getSoundRegistry().func_148742_b().forEach(rl -> this.myRegistry.put((ResourceLocation)rl, new SoundEvent(rl)));
    }

    @Nonnull
    public SoundEvent getSound(ResourceLocation sound2) {
        SoundEvent evt = this.myRegistry.get(sound2);
        if (evt == null) {
            ModBase.log().warn("Cannot find sound that should be registered [%s]", new Object[]{sound2.toString()});
            return new SoundEvent(sound2);
        }
        return evt;
    }

    public boolean isSoundBlocked(@Nonnull ResourceLocation sound2) {
        return this.blockedSounds.contains(sound2);
    }

    public boolean isSoundCulled(@Nonnull ResourceLocation sound2) {
        return this.soundCull.containsKey((Object)sound2);
    }

    public float getVolumeScale(@Nonnull ResourceLocation soundName) {
        return this.volumeControl.getFloat((Object)soundName);
    }

    public float getVolumeScale(@Nonnull ISound sound2) {
        return sound2.func_147650_b() == null || sound2 instanceof ConfigSoundInstance ? 1.0f : this.volumeControl.getFloat((Object)sound2.func_147650_b().toString());
    }

    @Nullable
    public SoundMetadata getSoundMetadata(@Nonnull ResourceLocation resource) {
        return this.soundMetadata.get(resource);
    }

    private boolean isSoundCulledLogical(@Nonnull ResourceLocation res) {
        int lastOccurance;
        if (ModOptions.sound.soundCullingThreshold > 0 && (lastOccurance = this.soundCull.getInt((Object)res)) != 0) {
            int currentTick = EnvironStateHandler.EnvironState.getTickCounter();
            if (currentTick - lastOccurance < ModOptions.sound.soundCullingThreshold) {
                return true;
            }
            this.soundCull.put((Object)res, currentTick);
        }
        return false;
    }

    private boolean blockSoundProcess(@Nonnull ResourceLocation res) {
        return res == null || this.isSoundBlocked(res) || this.isSoundCulledLogical(res);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void soundPlay(@Nonnull PlaySoundEvent e) {
        SoundEvent rep;
        ResourceLocation thunderSound;
        ISound theSound = e.getSound();
        if (theSound == null || theSound instanceof ConfigSoundInstance) {
            return;
        }
        ResourceLocation soundResource = theSound.func_147650_b();
        if (this.blockSoundProcess(soundResource)) {
            e.setResultSound(null);
            return;
        }
        if ("entity.lightning.thunder".equals(e.getName()) && !this.isSoundBlocked(thunderSound = Sounds.THUNDER.getSound().func_187503_a())) {
            PositionedSound sound2 = (PositionedSound)theSound;
            if (PositionedSoundUtil.getVolume((PositionedSound)sound2) > 16.0f) {
                BlockPos pos = new BlockPos((double)sound2.func_147649_g(), (double)sound2.func_147654_h(), (double)sound2.func_147651_i());
                SoundInstance newSound = Sounds.THUNDER.createSoundAt(pos).setVolume(ModOptions.sound.thunderVolume);
                e.setResultSound((ISound)newSound);
            }
            return;
        }
        if (theSound instanceof PositionedSound && (rep = (SoundEvent)this.replacements.get((Object)soundResource)) != null) {
            e.setResultSound((ISound)SoundBuilder.builder(rep).from((PositionedSound)theSound).build());
        }
    }
}

