/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.sound;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.SoundCategory;
import org.orecruncher.dsurround.registry.config.SoundMetadataConfig;
import org.orecruncher.dsurround.registry.sound.SoundRegistry;

public class SoundMetadata {
    protected final String title;
    protected final SoundCategory category;
    protected final List<String> credits;

    public SoundMetadata(@Nonnull SoundMetadataConfig cfg) {
        this.title = cfg.title;
        SoundCategory cat = this.translate(cfg.category);
        this.category = cat != null ? cat : SoundCategory.NEUTRAL;
        this.credits = ImmutableList.copyOf(cfg.credits);
    }

    protected SoundCategory translate(@Nonnull String catName) {
        if ("ds_biome".equals(catName)) {
            return SoundRegistry.BIOME;
        }
        if ("ds_footsteps".equals(catName)) {
            return SoundRegistry.FOOTSTEPS;
        }
        return SoundCategory.func_187950_a((String)catName);
    }

    public String getTitle() {
        return this.title;
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public List<String> getCredits() {
        return this.credits;
    }
}

