/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.item;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.SimpleItemData;

public final class ItemUtils {
    private static Field itemInfo = ReflectionHelper.findField(Item.class, (String[])new String[]{"dsurround_item_info"});

    @Nullable
    public static IItemData getItemData(@Nonnull Item item) {
        IItemData result = null;
        try {
            result = (IItemData)itemInfo.get(item);
            if (result == null) {
                RegistryManager.ITEMS.reload();
                result = (IItemData)itemInfo.get(item);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModBase.log().error("Unable to get hold of private field on Item!", (Throwable)e);
        }
        if (result == null) {
            ModBase.log().warn("Unable to find IItemData for item [%s]", new Object[]{item.toString()});
            result = (IItemData)SimpleItemData.CACHE.get((Object)ItemClass.NONE);
            ItemUtils.setItemData(item, result);
        }
        return result;
    }

    public static void setItemData(@Nonnull Item item, @Nonnull IItemData data) {
        try {
            itemInfo.set(item, data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModBase.log().error("Unable to set private field on Item!", (Throwable)e);
        }
    }
}

