/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.blockstate;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;

public final class BlockStateUtil {
    private static Field blockStateInfo = ReflectionHelper.findField(BlockStateBase.class, (String[])new String[]{"dsurround_blockstate_info"});

    @Nullable
    public static <T extends BlockStateData> T getStateData(@Nonnull IBlockState state) {
        try {
            return (T)((BlockStateData)blockStateInfo.get(state));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModBase.log().error("Unable to get hold of private field on BlockStateBase!", (Throwable)e);
            return null;
        }
    }

    public static <T extends BlockStateData> void setStateData(@Nonnull IBlockState state, @Nonnull T data) {
        try {
            blockStateInfo.set(state, data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModBase.log().error("Unable to set private field on BlockStateBase!", (Throwable)e);
        }
    }
}

