/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.blockstate;

import com.google.common.base.Joiner;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffect;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;
import org.orecruncher.lib.MyUtils;
import org.orecruncher.lib.WeightTable;

@SideOnly(value=Side.CLIENT)
public class BlockStateProfile
extends BlockStateData {
    public static final BlockEffect[] NO_EFFECTS = new BlockEffect[0];
    public static final SoundEffect[] NO_SOUNDS = new SoundEffect[0];
    protected int chance = 100;
    protected SoundEffect[] sounds = NO_SOUNDS;
    protected BlockEffect[] effects = NO_EFFECTS;
    protected BlockEffect[] alwaysOn = NO_EFFECTS;

    @Nonnull
    public BlockStateProfile setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    @Nonnull
    public BlockStateProfile addSound(@Nonnull SoundEffect sound2) {
        this.sounds = (SoundEffect[])MyUtils.append((Object[])this.sounds, (Object)sound2);
        return this;
    }

    @Nonnull
    public BlockStateProfile clearSounds() {
        this.sounds = NO_SOUNDS;
        return this;
    }

    @Nonnull
    public SoundEffect[] getSounds() {
        return this.sounds;
    }

    @Nonnull
    public BlockStateProfile addEffect(@Nonnull BlockEffect effect) {
        if (effect.getChance() > 0) {
            this.effects = (BlockEffect[])MyUtils.append((Object[])this.effects, (Object)effect);
        } else {
            this.alwaysOn = (BlockEffect[])MyUtils.append((Object[])this.alwaysOn, (Object)effect);
        }
        return this;
    }

    @Nonnull
    public BlockStateProfile clearEffects() {
        this.effects = NO_EFFECTS;
        this.alwaysOn = NO_EFFECTS;
        return this;
    }

    @Nonnull
    public BlockEffect[] getEffects() {
        return this.effects;
    }

    @Nonnull
    public BlockEffect[] getAlwaysOnEffects() {
        return this.alwaysOn;
    }

    @Nullable
    public SoundEffect getSoundToPlay(@Nonnull Random random) {
        return this.sounds != NO_SOUNDS && random.nextInt(this.getChance()) == 0 ? (SoundEffect)new WeightTable((WeightTable.IEntrySource[])this.sounds).next() : null;
    }

    public boolean hasSoundsOrEffects() {
        return this.sounds.length > 0 || this.effects.length > 0;
    }

    public boolean hasAlwaysOnEffects() {
        return this.alwaysOn.length > 0;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.sounds != NO_SOUNDS) {
            builder.append(" chance:").append(this.chance);
            builder.append("; sounds [");
            builder.append(Joiner.on((char)',').join((Object[])this.sounds));
            builder.append(']');
        } else {
            builder.append("NO SOUNDS");
        }
        if (this.effects != this.alwaysOn) {
            builder.append("; effects [");
            builder.append(Joiner.on((char)',').join((Object[])this.effects));
            builder.append(',');
            builder.append(Joiner.on((char)',').join((Object[])this.alwaysOn));
            builder.append(']');
        } else {
            builder.append("; NO EFFECTS");
        }
        return builder.toString();
    }
}

