/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.registry.biome.BiomeData;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.IBiome;

@SideOnly(value=Side.CLIENT)
public class FakeBiome
implements IBiome {
    private static int biomeIdCounter = -200;
    protected final int biomeId = --biomeIdCounter;
    protected final String name;
    protected final ResourceLocation key;
    protected BiomeData biomeData;

    public FakeBiome(@Nonnull String name) {
        this.name = name;
        this.key = new ResourceLocation("dsurround", ("fake_" + name).replace(' ', '_'));
    }

    @Nullable
    public BiomeData getBiomeData() {
        return this.biomeData;
    }

    public void setBiomeData(@Nullable BiomeData data) {
        this.biomeData = data;
    }

    @Override
    public int getId() {
        return this.biomeId;
    }

    @Override
    public boolean canRain() {
        return FakeBiome.getTrueBiome().canRain();
    }

    @Override
    public boolean getEnableSnow() {
        return FakeBiome.getTrueBiome().getEnableSnow();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return FakeBiome.getTrueBiome().getFloatTemperature(pos);
    }

    @Override
    public float getTemperature() {
        return FakeBiome.getTrueBiome().getTemperature();
    }

    @Override
    public Biome.TempCategory getTempCategory() {
        return FakeBiome.getTrueBiome().getTempCategory();
    }

    @Override
    public boolean isHighHumidity() {
        return FakeBiome.getTrueBiome().isHighHumidity();
    }

    @Override
    public float getRainfall() {
        BiomeInfo info = FakeBiome.getTrueBiome();
        return info == null ? 0.0f : info.getRainfall();
    }

    @Override
    public Biome getBiome() {
        return null;
    }

    @Override
    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<BiomeDictionary.Type> getTypes() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isFake() {
        return true;
    }

    private static BiomeInfo getTrueBiome() {
        return EnvironStateHandler.EnvironState.getTruePlayerBiome();
    }
}

