/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeData;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.WorldUtils;

public final class BiomeUtil {
    private static final Color NO_COLOR = new Color.ImmutableColor(1.0f, 1.0f, 1.0f);
    private static Field biomeInfo = ReflectionHelper.findField(Biome.class, (String[])new String[]{"dsurround_biome_info"});
    private static Field biomeName = ReflectionHelper.findField(Biome.class, (String[])new String[]{"biomeName", "field_76791_y"});
    private static Class<?> bopBiome = null;
    private static Field bopBiomeFogDensity = null;
    private static Field bopBiomeFogColor = null;

    @Nonnull
    public static <T extends BiomeData> T getBiomeData(@Nonnull Biome biome) {
        BiomeData result = null;
        try {
            if (biome != null && (result = (BiomeData)biomeInfo.get(biome)) == null) {
                RegistryManager.BIOME.reload();
                result = (BiomeData)biomeInfo.get(biome);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModBase.log().error("Unable to get hold of private field on Biome!", (Throwable)e);
        }
        if (result == null) {
            ModBase.log().warn("Unable to find configuration for biome [%s] (hc=%d)", new Object[]{biome.getRegistryName(), System.identityHashCode(biome)});
            result = RegistryManager.BIOME.WTF_INFO;
            BiomeUtil.setBiomeData(biome, result);
        }
        return (T)result;
    }

    public static <T extends BiomeData> void setBiomeData(@Nonnull Biome biome, @Nullable T data) {
        try {
            biomeInfo.set(biome, data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModBase.log().error("Unable to set private field on Biome!", (Throwable)e);
        }
    }

    @Nonnull
    public static String getBiomeName(@Nonnull Biome biome) {
        try {
            return (String)biomeName.get(biome);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return "UNKNOWN";
        }
    }

    public static boolean isBoPBiome(@Nonnull Biome biome) {
        return bopBiome != null && bopBiome.isInstance(biome);
    }

    public static int getBoPBiomeFogColor(@Nonnull Biome biome) {
        try {
            return bopBiomeFogColor != null ? bopBiomeFogColor.getInt(biome) : 0;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return 0;
        }
    }

    public static float getBoPBiomeFogDensity(@Nonnull Biome biome) {
        try {
            return bopBiomeFogDensity != null ? bopBiomeFogDensity.getFloat(biome) : 0.0f;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return 0.0f;
        }
    }

    public static Set<BiomeDictionary.Type> getBiomeTypes() {
        try {
            Field accessor = ReflectionHelper.findField(BiomeDictionary.Type.class, (String[])new String[]{"byName"});
            if (accessor != null) {
                Map stuff = (Map)accessor.get(null);
                return new ReferenceOpenHashSet(stuff.values());
            }
            return ImmutableSet.of();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot locate BiomeDictionary.Type table!");
        }
    }

    @Nonnull
    public static Color getBiomeWaterColor(@Nonnull World world, @Nonnull BlockPos pos) {
        return new Color(BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos));
    }

    @Nullable
    public static Color getColorForLiquid(@Nonnull World world, @Nonnull BlockPos pos) {
        return BiomeUtil.getColorForLiquid(world, WorldUtils.getBlockState((World)world, (BlockPos)pos), pos);
    }

    @Nonnull
    public static Color getColorForLiquid(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        Block liquid = state.func_177230_c();
        if (liquid == Blocks.field_150355_j) {
            return BiomeUtil.getBiomeWaterColor(world, pos);
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)liquid);
        if (fluid != null) {
            return new Color(fluid.getColor());
        }
        return NO_COLOR;
    }

    @Nonnull
    public static Set<BiomeDictionary.Type> getBiomeTypes(@Nonnull Biome biome) {
        return new ReferenceOpenHashSet((Collection)BiomeDictionary.getTypes((Biome)biome));
    }

    public static boolean areBiomesSimilar(@Nonnull Biome b1, @Nonnull Biome b2) {
        return BiomeDictionary.areSimilar((Biome)b1, (Biome)b2);
    }

    static {
        if (ModEnvironment.BiomesOPlenty.isLoaded()) {
            try {
                bopBiome = Class.forName("biomesoplenty.common.biome.BOPBiome");
                bopBiomeFogDensity = ReflectionHelper.findField(bopBiome, (String[])new String[]{"fogDensity"});
                bopBiomeFogColor = ReflectionHelper.findField(bopBiome, (String[])new String[]{"fogColor"});
            }
            catch (Throwable t) {
                bopBiome = null;
                bopBiomeFogDensity = null;
                bopBiomeFogColor = null;
            }
        }
    }
}

