/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeHandler;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.BiomeMatcher;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.dsurround.registry.biome.FakeBiome;
import org.orecruncher.dsurround.registry.biome.IBiome;
import org.orecruncher.dsurround.registry.biome.WTFFakeBiome;
import org.orecruncher.dsurround.registry.config.BiomeConfig;
import org.orecruncher.dsurround.registry.config.ConfigData;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.dsurround.registry.dimension.DimensionData;
import org.orecruncher.lib.logging.ModLog;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class BiomeRegistry
extends Registry {
    private static final int INSIDE_Y_ADJUST = 3;
    public static final FakeBiome UNDERGROUND = new FakeBiome("Underground");
    public static final FakeBiome PLAYER = new FakeBiome("Player");
    public static final FakeBiome UNDERWATER = new FakeBiome("Underwater");
    public static final FakeBiome UNDEROCEAN = new FakeBiome("UnderOCN");
    public static final FakeBiome UNDERDEEPOCEAN = new FakeBiome("UnderDOCN");
    public static final FakeBiome UNDERRIVER = new FakeBiome("UnderRVR");
    public static final FakeBiome OUTERSPACE = new FakeBiome("OuterSpace");
    public static final FakeBiome CLOUDS = new FakeBiome("Clouds");
    public static final FakeBiome VILLAGE = new FakeBiome("Village");
    public static final FakeBiome BATTLE_MUSIC = new FakeBiome("BattleMusic");
    public BiomeInfo UNDERGROUND_INFO;
    public BiomeInfo PLAYER_INFO;
    public BiomeInfo UNDERRIVER_INFO;
    public BiomeInfo UNDEROCEAN_INFO;
    public BiomeInfo UNDERDEEPOCEAN_INFO;
    public BiomeInfo UNDERWATER_INFO;
    public BiomeInfo VILLAGE_INFO;
    public BiomeInfo CLOUDS_INFO;
    public BiomeInfo OUTERSPACE_INFO;
    public BiomeInfo BATTLE_MUSIC_INFO;
    public BiomeInfo WTF_INFO;
    private static final FakeBiome WTF = new WTFFakeBiome();
    private final Map<String, String> biomeAliases = new Object2ObjectOpenHashMap();
    private final ObjectOpenHashSet<FakeBiome> theFakes = new ObjectOpenHashSet();

    public BiomeRegistry() {
        super("Biome Registry");
    }

    @Override
    protected void preInit() {
        this.biomeAliases.clear();
        this.theFakes.clear();
        for (String entry : ModOptions.biomes.biomeAliases) {
            String[] parts = StringUtils.split((String)entry, (String)"=");
            if (parts.length != 2) continue;
            this.biomeAliases.put(parts[0], parts[1]);
        }
        ForgeRegistries.BIOMES.getValuesCollection().forEach(biome -> this.register((Biome)biome));
        this.register(UNDERWATER);
        this.register(UNDEROCEAN);
        this.register(UNDERDEEPOCEAN);
        this.register(UNDERRIVER);
        this.register(PLAYER);
        this.register(VILLAGE);
        this.register(UNDERGROUND);
        this.register(CLOUDS);
        this.register(OUTERSPACE);
        this.register(BATTLE_MUSIC);
        this.UNDERGROUND_INFO = this.resolve(UNDERGROUND);
        this.PLAYER_INFO = this.resolve(PLAYER);
        this.UNDERRIVER_INFO = this.resolve(UNDERRIVER);
        this.UNDEROCEAN_INFO = this.resolve(UNDEROCEAN);
        this.UNDERDEEPOCEAN_INFO = this.resolve(UNDERDEEPOCEAN);
        this.UNDERWATER_INFO = this.resolve(UNDERWATER);
        this.VILLAGE_INFO = this.resolve(VILLAGE);
        this.CLOUDS_INFO = this.resolve(CLOUDS);
        this.OUTERSPACE_INFO = this.resolve(OUTERSPACE);
        this.BATTLE_MUSIC_INFO = this.resolve(BATTLE_MUSIC);
        this.register(WTF);
        this.WTF_INFO = this.resolve(WTF);
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        cfg.biomeAlias.forEach((alias, biome) -> this.registerBiomeAlias((String)alias, (String)biome));
        cfg.biomes.forEach(entry -> {
            BiomeMatcher matcher = BiomeMatcher.getMatcher(entry);
            this.getCombinedStream().filter(i -> matcher.match((BiomeInfo)i)).forEach(i -> i.update((BiomeConfig)entry));
        });
        ResourceLocation plainsLoc = new ResourceLocation("plains");
        Biome plains = (Biome)ForgeRegistries.BIOMES.getValue(plainsLoc);
        BiomeInfo info = (BiomeInfo)BiomeUtil.getBiomeData(plains);
        BiomeUtil.setBiomeData(Biomes.field_76772_c, info);
    }

    @Override
    protected void complete() {
        if (ModOptions.logging.enableDebugLogging) {
            ModBase.log().info("*** BIOME REGISTRY ***", new Object[0]);
            this.getCombinedStream().sorted().map(Object::toString).forEach(arg_0 -> BiomeRegistry.lambda$complete$5(ModBase.log(), arg_0));
        }
        this.biomeAliases.clear();
    }

    public void reload() {
        ModBase.log().info("Reloading biome registry...", new Object[0]);
        this.preInit();
        for (ModConfiguration mcf : (ConfigData)RegistryManager.DATA.get()) {
            this.init(mcf);
        }
        this.postInit();
        this.complete();
    }

    protected void register(@Nonnull Biome biome) {
        BiomeHandler handler = new BiomeHandler(biome);
        BiomeInfo info = new BiomeInfo(handler);
        BiomeUtil.setBiomeData(biome, info);
    }

    protected void register(@Nonnull IBiome biome) {
        if (biome.isFake()) {
            FakeBiome fb = (FakeBiome)biome;
            BiomeInfo info = new BiomeInfo(fb);
            fb.setBiomeData(info);
            this.theFakes.add((Object)fb);
        }
    }

    @Nullable
    protected BiomeInfo resolve(@Nonnull IBiome biome) {
        if (biome.isFake()) {
            FakeBiome fb = (FakeBiome)biome;
            return (BiomeInfo)fb.getBiomeData();
        }
        return null;
    }

    @Nonnull
    public BiomeInfo get(@Nonnull Biome biome) {
        return (BiomeInfo)BiomeUtil.getBiomeData(biome);
    }

    @Nonnull
    public BiomeInfo getPlayerBiome(@Nonnull EntityPlayer player2, boolean getTrue) {
        Biome biome = player2.func_130014_f_().func_180494_b(new BlockPos(player2.field_70165_t, 0.0, player2.field_70161_v));
        BiomeInfo info = this.get(biome);
        if (!getTrue) {
            if (player2.func_70055_a(Material.field_151586_h)) {
                info = info.isRiver() ? this.UNDERRIVER_INFO : (info.isDeepOcean() ? this.UNDERDEEPOCEAN_INFO : (info.isOcean() ? this.UNDEROCEAN_INFO : this.UNDERWATER_INFO));
            } else {
                DimensionData dimInfo = EnvironStateHandler.EnvironState.getDimensionInfo();
                int theY = MathStuff.floor((double)player2.field_70163_u);
                if (theY + 3 <= dimInfo.getSeaLevel()) {
                    info = this.UNDERGROUND_INFO;
                } else if (theY >= dimInfo.getSpaceHeight()) {
                    info = this.OUTERSPACE_INFO;
                } else if (theY >= dimInfo.getCloudHeight()) {
                    info = this.CLOUDS_INFO;
                }
            }
        }
        return info;
    }

    private void registerBiomeAlias(@Nonnull String alias, @Nonnull String biome) {
        this.biomeAliases.put(alias, biome);
    }

    private Stream<BiomeInfo> getCombinedStream() {
        Stream<BiomeInfo> s1 = ForgeRegistries.BIOMES.getValuesCollection().stream().map(biome -> (BiomeInfo)BiomeUtil.getBiomeData(biome)).filter(Objects::nonNull);
        Stream<BiomeInfo> s2 = this.theFakes.stream().map(fb -> (BiomeInfo)fb.getBiomeData());
        return Stream.of(s1, s2).flatMap(i -> i);
    }

    private static /* synthetic */ void lambda$complete$5(ModLog rec$, String x$0) {
        rec$.info(x$0, new Object[0]);
    }
}

