/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.footsteps.DelayedAcoustic;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.acoustics.EventSelectorAcoustics;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.NullAcoustic;
import org.orecruncher.dsurround.registry.acoustics.ProbabilityWeightsAcoustic;
import org.orecruncher.dsurround.registry.acoustics.SimpleAcoustic;
import org.orecruncher.dsurround.registry.acoustics.SimultaneousAcoustic;
import org.orecruncher.dsurround.registry.config.ModConfiguration;

@SideOnly(value=Side.CLIENT)
public class AcousticRegistry
extends Registry {
    private static final float default_volMin = 0.9f;
    private static final float default_volMax = 1.0f;
    private static final float default_pitchMin = 0.95f;
    private static final float default_pitchMax = 1.05f;
    private static final float DIVIDE = 100.0f;
    private final Map<String, IAcoustic> acoustics = new Object2ObjectAVLTreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IAcoustic[]> compiled = new Object2ObjectAVLTreeMap(String.CASE_INSENSITIVE_ORDER);
    public static final IAcoustic[] EMPTY = new IAcoustic[0];
    public static final IAcoustic[] NOT_EMITTER = new IAcoustic[]{new NullAcoustic("NOT_EMITTER")};
    public static final IAcoustic[] MESSY_GROUND = new IAcoustic[]{new NullAcoustic("MESSY_GROUND")};
    private int hits;

    public AcousticRegistry() {
        super("Acoustic Registry");
    }

    @Override
    protected void preInit() {
        this.hits = 0;
        this.acoustics.clear();
        this.compiled.clear();
        this.compiled.put("EMPTY", EMPTY);
        this.compiled.put("NOT_EMITTER", NOT_EMITTER);
        this.compiled.put("MESSY_GROUND", MESSY_GROUND);
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        for (Map.Entry<String, JsonElement> entry : cfg.acoustics.entrySet()) {
            String acousticsName = entry.getKey();
            try {
                JsonObject acousticsDefinition = entry.getValue().getAsJsonObject();
                EventSelectorAcoustics selector = new EventSelectorAcoustics(acousticsName);
                this.parseSelector(selector, acousticsDefinition);
                this.addAcoustic(selector);
            }
            catch (Throwable t) {
                String msg = String.format("Unable to parse Json entry [%s]!", acousticsName);
                ModBase.log().error(msg, t);
            }
        }
        for (Map.Entry<String, Object> entry : cfg.primitiveAcoustics.entrySet()) {
            this.compiled.put(entry.getKey(), this.compileAcoustics((String)entry.getValue()));
        }
    }

    @Override
    protected void complete() {
        ModBase.log().info("[%s] %d cache hits during initialization", new Object[]{this.getName(), this.hits});
    }

    @Nullable
    public IAcoustic[] getPrimitive(@Nonnull String primitive) {
        IAcoustic a;
        IAcoustic[] result = this.compiled.get(primitive);
        if (result == null && (a = this.generateAcoustic(primitive)) != null) {
            result = new IAcoustic[]{a};
            this.compiled.put(primitive, result);
        }
        return result;
    }

    @Nullable
    public IAcoustic[] getPrimitiveSubstrate(@Nonnull String primitive, @Nonnull String substrate) {
        return this.compiled.get(primitive + "@" + substrate);
    }

    public void addAcoustic(@Nonnull IAcoustic acoustic) {
        this.acoustics.put(acoustic.getName(), acoustic);
    }

    @Nullable
    public IAcoustic getAcoustic(@Nonnull String name) {
        return this.acoustics.get(name);
    }

    @Nonnull
    public IAcoustic[] compileAcoustics(@Nonnull SoundEvent evt) {
        IAcoustic[] result = this.compiled.get(evt.func_187503_a().toString());
        if (result == null) {
            IAcoustic a = this.generateAcoustic(evt);
            result = new IAcoustic[]{a};
            this.compiled.put(a.getName(), result);
        } else {
            ++this.hits;
        }
        return result;
    }

    @Nonnull
    public IAcoustic[] compileAcoustics(@Nonnull String acousticName) {
        IAcoustic[] result = this.compiled.get(acousticName);
        if (result == null) {
            result = (IAcoustic[])Arrays.stream(acousticName.split(",")).map(fragment -> {
                IAcoustic a = this.generateAcoustic((String)fragment);
                if (a == null) {
                    ModBase.log().warn("Acoustic '%s' not found!", new Object[]{fragment});
                }
                return a;
            }).filter(Objects::nonNull).toArray(IAcoustic[]::new);
            if (result == null || result.length == 0) {
                result = EMPTY;
            }
            this.compiled.put(acousticName, result);
        } else {
            ++this.hits;
        }
        return result;
    }

    @Nullable
    private IAcoustic generateAcoustic(@Nonnull String name) {
        ResourceLocation loc;
        SoundEvent evt;
        IAcoustic a = this.acoustics.get(name);
        if (a == null && (evt = RegistryManager.SOUND.getSound(loc = new ResourceLocation(name))) != null) {
            a = this.generateAcoustic(evt);
        }
        return a;
    }

    @Nonnull
    private IAcoustic generateAcoustic(@Nonnull SoundEvent evt) {
        IAcoustic result = this.acoustics.get(evt.func_187503_a().toString());
        if (result == null) {
            result = new SimpleAcoustic(evt);
            this.acoustics.put(result.getName(), result);
        }
        return result;
    }

    private void parseSelector(EventSelectorAcoustics selector, JsonObject acousticsDefinition) {
        for (EventType i : EventType.values()) {
            String eventName = i.jsonName();
            if (!acousticsDefinition.has(eventName)) continue;
            JsonElement unsolved = acousticsDefinition.get(eventName);
            IAcoustic acoustic = this.solveAcoustic(unsolved);
            selector.setAcousticPair(i, acoustic);
        }
    }

    private IAcoustic solveAcoustic(JsonElement unsolved) {
        IAcoustic ret = null;
        if (unsolved.isJsonObject()) {
            ret = this.solveAcousticsCompound(unsolved.getAsJsonObject());
        } else if (unsolved.isJsonPrimitive() && unsolved.getAsJsonPrimitive().isString()) {
            SimpleAcoustic a = new SimpleAcoustic();
            this.prepareDefaults(a);
            this.setupSoundName(a, unsolved.getAsString());
            ret = a;
        }
        if (ret == null) {
            throw new IllegalStateException("Unresolved Json element: \r\n" + unsolved.toString());
        }
        return ret;
    }

    private IAcoustic solveAcousticsCompound(JsonObject unsolved) {
        IAcoustic ret = null;
        if (!unsolved.has("type") || unsolved.get("type").getAsString().equals("basic")) {
            SimpleAcoustic a = new SimpleAcoustic();
            this.prepareDefaults(a);
            this.setupClassics(a, unsolved);
            ret = a;
        } else {
            String type = unsolved.get("type").getAsString();
            if (type.equals("simultaneous")) {
                ArrayList<IAcoustic> acoustics = new ArrayList<IAcoustic>();
                JsonArray sim = unsolved.getAsJsonArray("array");
                for (JsonElement subElement : sim) {
                    acoustics.add(this.solveAcoustic(subElement));
                }
                SimultaneousAcoustic a = new SimultaneousAcoustic(acoustics);
                ret = a;
            } else if (type.equals("delayed")) {
                DelayedAcoustic a = new DelayedAcoustic();
                this.prepareDefaults(a);
                this.setupClassics(a, unsolved);
                if (unsolved.has("delay")) {
                    a.setDelayMin(unsolved.get("delay").getAsInt());
                    a.setDelayMax(unsolved.get("delay").getAsInt());
                } else {
                    a.setDelayMin(unsolved.get("delay_min").getAsInt());
                    a.setDelayMax(unsolved.get("delay_max").getAsInt());
                }
                ret = a;
            } else if (type.equals("probability")) {
                ArrayList<Integer> weights = new ArrayList<Integer>();
                ArrayList<IAcoustic> acoustics = new ArrayList<IAcoustic>();
                JsonArray sim = unsolved.getAsJsonArray("array");
                Iterator iter = sim.iterator();
                while (iter.hasNext()) {
                    JsonElement subElement = (JsonElement)iter.next();
                    weights.add(subElement.getAsInt());
                    if (!iter.hasNext()) {
                        throw new IllegalStateException("Probability has odd number of children!");
                    }
                    subElement = (JsonElement)iter.next();
                    acoustics.add(this.solveAcoustic(subElement));
                }
                ProbabilityWeightsAcoustic a = new ProbabilityWeightsAcoustic(acoustics, weights);
                ret = a;
            }
        }
        return ret;
    }

    private void prepareDefaults(@Nonnull SimpleAcoustic a) {
        a.setVolMin(0.9f);
        a.setVolMax(1.0f);
        a.setPitchMin(0.95f);
        a.setPitchMax(1.05f);
    }

    private void setupSoundName(@Nonnull SimpleAcoustic a, @Nonnull String soundName) {
        try {
            ResourceLocation res = "@".equals(soundName) ? null : (soundName.contains(":") ? new ResourceLocation(soundName) : (soundName.charAt(0) != '@' ? new ResourceLocation("dsurround", soundName) : new ResourceLocation("minecraft", soundName.substring(1))));
            if (res == null) {
                a.setSound(null);
            } else {
                a.setSound(RegistryManager.SOUND.getSound(res));
            }
        }
        catch (Throwable t) {
            ModBase.log().warn("Unable to locate sound [%s]", new Object[]{soundName});
            a.setSound(null);
        }
    }

    private void setupClassics(SimpleAcoustic a, JsonObject solved) {
        this.setupSoundName(a, solved.get("name").getAsString());
        if (solved.has("vol_min")) {
            a.setVolMin(this.processPitchOrVolume(solved, "vol_min"));
        }
        if (solved.has("vol_max")) {
            a.setVolMax(this.processPitchOrVolume(solved, "vol_max"));
        }
        if (solved.has("pitch_min")) {
            a.setPitchMin(this.processPitchOrVolume(solved, "pitch_min"));
        }
        if (solved.has("pitch_max")) {
            a.setPitchMax(this.processPitchOrVolume(solved, "pitch_max"));
        }
    }

    private float processPitchOrVolume(@Nonnull JsonObject object, @Nonnull String param) {
        return object.get(param).getAsFloat() / 100.0f;
    }
}

