/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.sound;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.MusicFader;
import org.orecruncher.dsurround.client.sound.SoundState;
import org.orecruncher.dsurround.client.sound.TrackingSoundInstance;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.lib.ThreadGuard;
import org.orecruncher.lib.math.MathStuff;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dsurround")
public final class SoundEngine {
    private static Field soundPhysicsGlobalVolume;
    private static final Field getSoundManager;
    private static final Field getSoundRegistry;
    private static final Field getSoundSystem;
    private static final Field getPlayingSounds;
    private static final Field getPlayingSoundsInv;
    private static final Field getDelayedSounds;
    private static final Field getSoundLibrary;
    private static final Field removed;
    private static final float MUTE_VOLUME = 1.0E-5f;
    private static final int MAX_STREAM_CHANNELS = 16;
    private static final int SOUND_QUEUE_SLACK = 6;
    private static int maxSounds;
    private static SoundEngine instance_;
    private final ThreadGuard guard = new ThreadGuard(ModBase.log(), Side.CLIENT, "SoundManager").setAction(ModBase.isDeveloperMode() ? ThreadGuard.Action.EXCEPTION : (ModOptions.logging.enableDebugLogging ? ThreadGuard.Action.LOG : ThreadGuard.Action.NONE));
    private final Set<ISoundInstance> queuedSounds = new ReferenceOpenHashSet(256);
    private String playedSoundId = null;

    public static SoundEngine instance() {
        return instance_;
    }

    private SoundEngine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public SoundRegistry getSoundRegistry() {
        return (SoundRegistry)this.resolve(getSoundRegistry, Minecraft.func_71410_x().func_147118_V());
    }

    @Nonnull
    public SoundManager getSoundManager() {
        return (SoundManager)this.resolve(getSoundManager, Minecraft.func_71410_x().func_147118_V());
    }

    private <T> T resolve(@Nonnull Field f, @Nonnull Object obj) {
        try {
            return (T)f.get(obj);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int currentSoundCount() {
        try {
            Object object = SoundSystemConfig.THREAD_SYNC;
            synchronized (object) {
                return this.getSoundLibrary().getSources().size();
            }
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private boolean canFitSound() {
        return this.currentSoundCount() < maxSounds - 6;
    }

    private void flushSoundQueue() {
        this.getSoundSystem().CommandQueue(null);
    }

    private SoundSystem getSoundSystem() {
        return (SoundSystem)this.resolve(getSoundSystem, this.getSoundManager());
    }

    private Library getSoundLibrary() {
        return (Library)this.resolve(getSoundLibrary, this.getSoundSystem());
    }

    private Map<String, ISound> getPlayingSounds() {
        return (Map)this.resolve(getPlayingSounds, this.getSoundManager());
    }

    private Map<ISound, String> getPlayingSoundsInv() {
        return (Map)this.resolve(getPlayingSoundsInv, this.getSoundManager());
    }

    private Map<ISound, Integer> getDelayedSounds() {
        return (Map)this.resolve(getDelayedSounds, this.getSoundManager());
    }

    public boolean isSoundPlaying(@Nonnull ISoundInstance sound2) {
        return sound2.getState().isActive() && this.queuedSounds.contains(sound2);
    }

    public void stopSound(@Nonnull ISoundInstance sound2) {
        this.getSoundManager().func_148602_b((ISound)sound2);
    }

    public void stopAllSounds() {
        this.getSoundManager().func_148614_c();
        this.flushSoundQueue();
        this.clearOrphans();
    }

    public boolean playSound(@Nonnull ISoundInstance sound2) {
        if (this.queuedSounds.contains(sound2)) {
            return sound2.getState().isActive();
        }
        sound2.setState(SoundState.ERROR);
        if (this.canFitSound()) {
            this.playedSoundId = null;
            try {
                this.getSoundManager().func_148611_c((ISound)sound2);
                if (this.playedSoundId != null) {
                    this.queuedSounds.add(sound2);
                    sound2.setState(SoundState.PLAYING);
                }
            }
            catch (Throwable t) {
                String txt = String.format("Unable to play sound [%s]", sound2);
                ModBase.log().error(txt, t);
            }
        }
        if (ModBase.log().testTrace(1)) {
            if (sound2.getState().isActive()) {
                ModBase.log().debug("> QUEUED: [%s]", new Object[]{sound2});
            } else {
                ModBase.log().debug("> NOT QUEUED: [%s]", new Object[]{sound2});
            }
        }
        return sound2.getState().isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOrphans() {
        Map<String, ISound> playingSounds = this.getPlayingSounds();
        SoundSystem sndSystem = this.getSoundSystem();
        Object object = SoundSystemConfig.THREAD_SYNC;
        synchronized (object) {
            HashMap sounds = this.getSoundLibrary().getSources();
            List<String> remove = sounds.entrySet().stream().filter(e -> !playingSounds.containsKey(e.getKey())).map(e -> {
                Source src = (Source)e.getValue();
                ModBase.log().debug("Killing orphaned sound [%s]", new Object[]{src.filenameURL != null ? src.filenameURL.getFilename() : "UNKNOWN"});
                SoundEngine.cleanupSource(src);
                return (String)e.getKey();
            }).collect(Collectors.toList());
            remove.forEach(id -> sndSystem.removeSource(id));
        }
    }

    private static void cleanupSource(Source source) {
        if (source.toStream) {
            try {
                removed.setBoolean(source, true);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else {
            source.cleanup();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            Map<ISound, Integer> delayedSounds = this.getDelayedSounds();
            Map<ISound, String> playingInv = this.getPlayingSoundsInv();
            this.queuedSounds.removeIf(sound2 -> {
                switch (sound2.getState()) {
                    case DELAYED: {
                        if (delayedSounds.containsKey(sound2)) break;
                        if (playingInv.containsKey(sound2)) {
                            sound2.setState(SoundState.PLAYING);
                            break;
                        }
                        sound2.setState(SoundState.DONE);
                        break;
                    }
                    case PLAYING: {
                        if (playingInv.containsKey(sound2)) break;
                        if (delayedSounds.containsKey(sound2)) {
                            sound2.setState(SoundState.DELAYED);
                            break;
                        }
                        sound2.setState(SoundState.DONE);
                        break;
                    }
                }
                return !sound2.getState().isActive();
            });
        }
    }

    public boolean isMuted() {
        try {
            return this.getSoundSystem().getMasterVolume() == 1.0E-5f;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void setMuted(boolean flag) {
        try {
            if (flag) {
                this.getSoundSystem().setMasterVolume(1.0E-5f);
            } else {
                GameSettings options = Minecraft.func_71410_x().field_71474_y;
                if (options != null) {
                    this.getSoundSystem().setMasterVolume(options.func_186711_a(SoundCategory.MASTER));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onSoundSourceEvent(@Nonnull SoundEvent.SoundSourceEvent event) {
        this.guard.check("playSound");
        this.playedSoundId = event.getUuid();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void diagnostics(DiagnosticEvent.Gather event) {
        event.output.add("SoundSystem: " + this.currentSoundCount() + "/" + maxSounds);
        List results = this.getPlayingSounds().values().stream().map(s -> s.func_184364_b().func_188719_a()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> TextFormatting.GOLD + ((ResourceLocation)e.getKey()).toString() + ": " + String.valueOf(e.getValue())).sorted().collect(Collectors.toList());
        event.output.addAll(results);
    }

    public static float getVolume(@Nonnull SoundCategory category) {
        if (category == null || category == SoundCategory.MASTER) {
            return 1.0f;
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        return settings != null ? settings.func_186711_a(category) : 1.0f;
    }

    private static boolean fadeMusic(@Nonnull ISound sound2) {
        return sound2.func_184365_d() == SoundCategory.MUSIC && !(sound2 instanceof ConfigSoundInstance) && (!(sound2 instanceof TrackingSoundInstance) || !ModOptions.sound.enableBattleMusic);
    }

    private static float getVolumeScale(@Nonnull ISound sound2) {
        try {
            float fade = SoundEngine.fadeMusic(sound2) ? MusicFader.getMusicScaling() : 1.0f;
            return RegistryManager.SOUND.getVolumeScale(sound2) * fade;
        }
        catch (Throwable throwable) {
            return 1.0f;
        }
    }

    public static float getClampedVolume(@Nonnull ISound sound2) {
        float volumeScale = SoundEngine.getVolumeScale(sound2);
        float volume = sound2.func_147653_e() * SoundEngine.getVolume(sound2.func_184365_d()) * volumeScale;
        float result = MathStuff.clamp((float)volume, (float)0.0f, (float)1.0f);
        try {
            if (soundPhysicsGlobalVolume != null) {
                return result * soundPhysicsGlobalVolume.getFloat(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void alErrorCheck() {
        int error = AL10.alGetError();
        if (error != 0) {
            ModBase.log().warn("OpenAL error: %d", new Object[]{error});
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void configureSound(@Nonnull SoundSetupEvent event) {
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
                SoundEngine.alErrorCheck();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            SoundEngine.alErrorCheck();
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int normalChannelCount = ModOptions.sound.normalSoundChannelCount;
        int streamChannelCount = ModOptions.sound.streamingSoundChannelCount;
        if (ModOptions.sound.autoConfigureChannels && totalChannels > 64) {
            streamChannelCount = Math.min((totalChannels -= 32) / 8, 16);
            normalChannelCount = totalChannels - streamChannelCount;
        }
        ModBase.log().info("Sound channels: %d normal, %d streaming (total avail: %s)", new Object[]{normalChannelCount, streamChannelCount, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels)});
        SoundSystemConfig.setNumberNormalChannels((int)normalChannelCount);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannelCount);
        maxSounds = SoundSystemConfig.getNumberNormalChannels() + SoundSystemConfig.getNumberStreamingChannels();
        if (ModOptions.sound.streamBufferCount != 0) {
            SoundSystemConfig.setNumberStreamingBuffers((int)ModOptions.sound.streamBufferCount);
        }
        if (ModOptions.sound.streamBufferSize != 0) {
            SoundSystemConfig.setStreamingBufferSize((int)(ModOptions.sound.streamBufferSize * 1024));
        }
        ModBase.log().info("Stream buffers: %d x %d", new Object[]{SoundSystemConfig.getNumberStreamingBuffers(), SoundSystemConfig.getStreamingBufferSize()});
    }

    static {
        getSoundManager = ReflectionHelper.findField(SoundHandler.class, (String[])new String[]{"sndManager", "field_147694_f"});
        getSoundRegistry = ReflectionHelper.findField(SoundHandler.class, (String[])new String[]{"soundRegistry", "field_147697_e"});
        getSoundSystem = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"sndSystem", "field_148620_e"});
        getPlayingSounds = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"playingSounds", "field_148629_h"});
        getPlayingSoundsInv = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"invPlayingSounds", "field_148630_i"});
        getDelayedSounds = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"delayedSounds", "field_148626_m"});
        getSoundLibrary = ReflectionHelper.findField(SoundSystem.class, (String[])new String[]{"soundLibrary"});
        removed = ReflectionHelper.findField(Source.class, (String[])new String[]{"removed"});
        maxSounds = 0;
        instance_ = new SoundEngine();
        try {
            Class<?> soundPhysics = Class.forName("com.sonicether.soundphysics.SoundPhysics");
            soundPhysicsGlobalVolume = ReflectionHelper.findField(soundPhysics, (String[])new String[]{"globalVolumeMultiplier"});
        }
        catch (Exception ex) {
            soundPhysicsGlobalVolume = null;
        }
    }
}

