/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.hud;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.hud.GuiOverlay;
import org.orecruncher.dsurround.client.hud.InspectionHUD;

@SideOnly(value=Side.CLIENT)
public final class GuiHUDHandler {
    private static GuiHUDHandler INSTANCE;
    private final List<GuiOverlay> overlays = new ArrayList<GuiOverlay>();

    private GuiHUDHandler() {
        this.register(new InspectionHUD());
    }

    public void register(GuiOverlay overlay) {
        this.overlays.add(overlay);
    }

    public static void register() {
        INSTANCE = new GuiHUDHandler();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void unregister() {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            INSTANCE = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).doRender(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).doRender(event);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        int tickRef = EnvironStateHandler.EnvironState.getTickCounter();
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).doTick(tickRef);
        }
    }
}

