/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.effects.IEntityEffectHandlerState;
import org.orecruncher.dsurround.client.footsteps.Generator;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EntityFootprintEffect
extends EntityEffect {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected Generator generator;
    protected int lastStyle;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("footprint");

    @Override
    public String name() {
        return "Footstep/Prints";
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectHandlerState state) {
        super.intitialize(state);
        EntityLivingBase entity = (EntityLivingBase)this.getState().subject().get();
        this.generator = RegistryManager.FOOTSTEPS.createGenerator(entity);
        this.lastStyle = ModOptions.effects.footprintStyle;
    }

    @Override
    public void update(@Nonnull Entity subject) {
        EntityLivingBase entity = (EntityLivingBase)subject;
        if (this.lastStyle != ModOptions.effects.footprintStyle && this.getState().isActivePlayer((Entity)entity)) {
            this.generator = RegistryManager.FOOTSTEPS.createGenerator(entity);
            this.lastStyle = ModOptions.effects.footprintStyle;
        }
        this.generator.generateFootsteps(entity);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.generator.getPedometer();
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityFootprintEffect());
        }
    }
}

