/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilitySpeechData;
import org.orecruncher.dsurround.capabilities.speech.ISpeechData;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;
import org.orecruncher.lib.Translations;
import org.orecruncher.lib.WeightTable;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.compat.EntityUtil;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EntityChatEffect
extends EntityEffect {
    private static final String SPLASH_TOKEN = "$MINECRAFT$";
    private static final ResourceLocation SPLASH_TEXT = new ResourceLocation("texts/splashes.txt");
    private static final Translations xlate = new Translations();
    private static final ObjectArray<String> minecraftSplashText = new ObjectArray();
    private static final Map<String, EntityChatData> messages = new Object2ObjectOpenHashMap();
    protected final Random random = XorShiftRandom.current();
    protected final EntityChatData data;
    protected long nextChat;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER;

    protected static void setTimers(@Nonnull Class<? extends Entity> entity, int base, int random) {
        EntityChatEffect.setTimers(EntityUtil.getClassName(entity), base, random);
    }

    static void setTimers(@Nonnull String entity, int base, int random) {
        EntityChatData data = messages.get(entity);
        if (data != null) {
            data.baseInterval = base;
            data.baseRandom = random;
        }
    }

    protected static boolean hasMessages(@Nonnull Entity entity) {
        return !(entity instanceof EntityPlayer) && messages.get(EntityUtil.getClassName(entity.getClass())) != null;
    }

    private String getSpeechFormatted(@Nonnull Entity entity, @Nonnull String message) {
        String xlated = xlate.loadString(message);
        if (minecraftSplashText.size() > 0 && SPLASH_TOKEN.equals(xlated)) {
            xlated = (String)minecraftSplashText.get(this.random.nextInt(minecraftSplashText.size()));
        }
        return xlated;
    }

    public EntityChatEffect(@Nonnull Entity entity) {
        this(entity, null);
    }

    public EntityChatEffect(@Nonnull Entity entity, @Nullable String entityName) {
        String theName = StringUtils.isEmpty((CharSequence)entityName) ? EntityUtil.getClassName(entity.getClass()) : entityName;
        this.data = messages.get(theName);
        this.nextChat = this.getWorldTicks(entity) + (long)this.getNextChatTime();
    }

    @Override
    public String name() {
        return "Entity Chat";
    }

    protected int getBase() {
        return this.data.baseInterval;
    }

    protected int getRandom() {
        return this.data.baseRandom;
    }

    protected long getWorldTicks(Entity e) {
        return e.func_130014_f_().func_82737_E();
    }

    protected String getChatMessage(@Nonnull Entity entity) {
        return xlate.loadString(this.getSpeechFormatted(entity, (String)this.data.table.next()));
    }

    protected int getNextChatTime() {
        return this.getBase() + this.random.nextInt(this.getRandom());
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.speechbubbles.enableEntityChat) {
            return;
        }
        long ticks = this.getWorldTicks(subject);
        long delta = this.nextChat - ticks;
        if (delta <= 0L) {
            ISpeechData data = CapabilitySpeechData.getCapability(subject);
            if (data != null) {
                int expiry = (int)(ModOptions.speechbubbles.speechBubbleDuration * 20.0f);
                data.addMessage(this.getChatMessage(subject), expiry);
            }
            this.genNextChatTime();
        }
    }

    public void genNextChatTime() {
        this.nextChat = this.getWorldTicks(this.getState().subject().get()) + (long)this.getNextChatTime();
    }

    static {
        xlate.load("/assets/dsurround/dsurround/data/chat/", new String[0]);
        xlate.forAll((Predicate)new WeightTableBuilder());
        xlate.transform((Function)new Stripper());
        EntityChatEffect.setTimers(EntitySquid.class, 600, 1200);
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXT);){
            String s;
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(resource.func_110527_b(), Charsets.UTF_8));
            while ((s = bufferedreader.readLine()) != null) {
                if ((s = s.trim()).isEmpty()) continue;
                minecraftSplashText.add((Object)s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_FILTER = (e, eei) -> eei.effects.contains("chat") && !(e instanceof EntityVillager) && EntityChatEffect.hasMessages(e);
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityChatEffect(entity));
        }
    }

    private static class Stripper
    implements Function<Map.Entry<String, String>, String> {
        private final Pattern WEIGHT_PATTERN = Pattern.compile("^([0-9]*),(.*)");

        private Stripper() {
        }

        public String apply(@Nonnull Map.Entry<String, String> input) {
            Matcher matcher = this.WEIGHT_PATTERN.matcher(input.getValue());
            return matcher.matches() ? matcher.group(2) : input.getValue();
        }
    }

    private static class WeightTableBuilder
    implements Predicate<Map.Entry<String, String>> {
        private final Pattern TYPE_PATTERN = Pattern.compile("chat\\.([a-zA-Z.]*)\\.[0-9]*$");
        private final Pattern WEIGHT_PATTERN = Pattern.compile("^([0-9]*),(.*)");

        public boolean apply(@Nonnull Map.Entry<String, String> input) {
            Matcher matcher1 = this.TYPE_PATTERN.matcher(input.getKey());
            if (matcher1.matches()) {
                String key = matcher1.group(1).toLowerCase();
                Matcher matcher2 = this.WEIGHT_PATTERN.matcher(input.getValue());
                if (matcher2.matches()) {
                    EntityChatData data = (EntityChatData)messages.get(key);
                    if (data == null) {
                        data = new EntityChatData();
                        messages.put(key, data);
                    }
                    final int weight = Integer.parseInt(matcher2.group(1));
                    final String item = matcher2.group(2);
                    data.table.add((WeightTable.IItem)new WeightTable.IItem<String>(){

                        public int getWeight() {
                            return weight;
                        }

                        public String getItem() {
                            return item;
                        }
                    });
                } else {
                    ModBase.log().warn("Invalid value in language file: %s", new Object[]{input.getValue()});
                }
            } else {
                ModBase.log().warn("Invalid key in language file: %s", new Object[]{input.getKey()});
            }
            return true;
        }
    }

    static class EntityChatData {
        public static final int DEFAULT_INTERVAL = 400;
        public static final int DEFAULT_RANDOM = 1200;
        public int baseInterval = 400;
        public int baseRandom = 1200;
        public final WeightTable<String> table = new WeightTable();

        EntityChatData() {
        }
    }
}

