/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.effects.IEntityEffectHandlerState;
import org.orecruncher.dsurround.client.fx.particle.ParticleBubbleBreath;
import org.orecruncher.dsurround.client.fx.particle.ParticleFrostBreath;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;

@SideOnly(value=Side.CLIENT)
public class BreathEffect
extends EntityEffect {
    private static final int PRIME = 311;
    private int seed;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("breath");

    @Override
    public String name() {
        return "Breath";
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectHandlerState state) {
        super.intitialize(state);
        this.seed = state.subject().get().func_145782_y() * 311;
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.effects.showBreath) {
            return;
        }
        if (this.isBreathVisible(subject)) {
            int c = (int)(this.getState().getWorldTime() + (long)this.seed);
            IBlockState state = this.getHeadBlock(subject);
            if (this.showWaterBubbles(subject, state)) {
                int air = subject.func_70086_ai();
                if (air > 0) {
                    int interval = c % 3;
                    if (interval == 0) {
                        ParticleBubbleBreath particle = new ParticleBubbleBreath(subject);
                        this.getState().addParticle((Particle)particle);
                    }
                } else if (air == 0) {
                    for (int i = 0; i < 8; ++i) {
                        ParticleBubbleBreath particle = new ParticleBubbleBreath(subject, true);
                        this.getState().addParticle((Particle)particle);
                    }
                }
            } else {
                int interval = c / 10 % 8;
                if (interval < 3 && this.showFrostBreath(subject, state)) {
                    this.getState().addParticle((Particle)new ParticleFrostBreath(subject));
                }
            }
        }
    }

    protected boolean isBreathVisible(@Nonnull Entity entity) {
        EntityPlayer player2 = this.getState().thePlayer();
        return entity == player2 || !entity.func_98034_c(player2) && player2.func_70685_l(entity);
    }

    protected IBlockState getHeadBlock(Entity entity) {
        double d0 = entity.field_70163_u + (double)entity.func_70047_e();
        BlockPos blockpos = new BlockPos(entity.field_70165_t, d0, entity.field_70161_v);
        return entity.func_130014_f_().func_180495_p(blockpos);
    }

    protected boolean showWaterBubbles(Entity entity, @Nonnull IBlockState headBlock) {
        return headBlock.func_185904_a().func_76224_d();
    }

    protected boolean showFrostBreath(Entity entity, @Nonnull IBlockState headBlock) {
        if (headBlock.func_185904_a() == Material.field_151579_a) {
            World world = entity.func_130014_f_();
            BlockPos entityPos = entity.func_180425_c();
            return CapabilitySeasonInfo.getCapability(world).showFrostBreath(entityPos);
        }
        return false;
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new BreathEffect());
        }
    }
}

